/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.core.executor;

import com.biz.crm.core.biz.AdminBiz;
import com.biz.crm.core.biz.client.AdminBizClient;
import com.biz.crm.core.handler.IJobHandler;
import com.biz.crm.core.server.EmbedServer;
import com.biz.crm.core.thread.JobLogFileCleanThread;
import com.biz.crm.core.thread.JobThread;
import com.biz.crm.core.thread.TriggerCallbackThread;
import com.biz.crm.core.util.IpUtil;
import com.biz.crm.core.util.NetUtil;
import com.biz.crm.core.xxllog.XxlJobFileAppender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobExecutor {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobExecutor.class);
    private String adminAddresses;
    private String accessToken;
    private String appname;
    private String address;
    private String ip;
    private int port;
    private String logPath;
    private int logRetentionDays;
    private static List<AdminBiz> adminBizList;
    private EmbedServer embedServer = null;
    private static ConcurrentMap<String, IJobHandler> jobHandlerRepository;
    private static ConcurrentMap<String, JobThread> jobThreadRepository;

    public void setAdminAddresses(String adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setLogRetentionDays(int logRetentionDays) {
        this.logRetentionDays = logRetentionDays;
    }

    public void start() throws Exception {
        XxlJobFileAppender.initLogPath(this.logPath);
        this.initAdminBizList(this.adminAddresses, this.accessToken);
        JobLogFileCleanThread.getInstance().start(this.logRetentionDays);
        TriggerCallbackThread.getInstance().start();
        this.initEmbedServer(this.address, this.ip, this.port, this.appname, this.accessToken);
    }

    public void destroy() {
        this.stopEmbedServer();
        if (jobThreadRepository.size() > 0) {
            for (Map.Entry item : jobThreadRepository.entrySet()) {
                JobThread oldJobThread = XxlJobExecutor.removeJobThread((String)item.getKey(), "web container destroy and kill the job.");
                if (oldJobThread == null) continue;
                try {
                    oldJobThread.join();
                }
                catch (InterruptedException e) {
                    logger.error(">>>>>>>>>>> xxl-job, JobThread destroy(join) error, jobId:{}", item.getKey(), (Object)e);
                }
            }
            jobThreadRepository.clear();
        }
        jobHandlerRepository.clear();
        JobLogFileCleanThread.getInstance().toStop();
        TriggerCallbackThread.getInstance().toStop();
    }

    private void initAdminBizList(String adminAddresses, String accessToken) throws Exception {
        if (adminAddresses != null && adminAddresses.trim().length() > 0) {
            for (String address : adminAddresses.trim().split(",")) {
                if (address == null || address.trim().length() <= 0) continue;
                AdminBizClient adminBiz = new AdminBizClient(address.trim(), accessToken);
                if (adminBizList == null) {
                    adminBizList = new ArrayList<AdminBiz>();
                }
                adminBizList.add(adminBiz);
            }
        }
    }

    public static List<AdminBiz> getAdminBizList() {
        return adminBizList;
    }

    private void initEmbedServer(String address, String ip, int port, String appname, String accessToken) throws Exception {
        port = port > 0 ? port : NetUtil.findAvailablePort(9999);
        String string = ip = ip != null && ip.trim().length() > 0 ? ip : IpUtil.getIp();
        if (address == null || address.trim().length() == 0) {
            String ip_port_address = IpUtil.getIpPort(ip, port);
            address = "http://{ip_port}/".replace("{ip_port}", ip_port_address);
        }
        this.embedServer = new EmbedServer();
        this.embedServer.start(address, port, appname, accessToken);
    }

    private void stopEmbedServer() {
        try {
            this.embedServer.stop();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static IJobHandler registJobHandler(String name, IJobHandler jobHandler) {
        logger.info(">>>>>>>>>>> xxl-job register jobhandler success, name:{}, jobHandler:{}", (Object)name, (Object)jobHandler);
        return jobHandlerRepository.put(name, jobHandler);
    }

    public static IJobHandler loadJobHandler(String name) {
        return (IJobHandler)jobHandlerRepository.get(name);
    }

    public static JobThread registJobThread(String jobId, IJobHandler handler, String removeOldReason) {
        JobThread newJobThread = new JobThread(jobId, handler);
        newJobThread.start();
        logger.info(">>>>>>>>>>> xxl-job regist JobThread success, jobId:{}, handler:{}", new Object[]{jobId, handler});
        JobThread oldJobThread = jobThreadRepository.put(jobId, newJobThread);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
        }
        return newJobThread;
    }

    public static JobThread removeJobThread(String jobId, String removeOldReason) {
        JobThread oldJobThread = (JobThread)jobThreadRepository.remove(jobId);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
            return oldJobThread;
        }
        return null;
    }

    public static JobThread loadJobThread(String jobId) {
        JobThread jobThread = (JobThread)jobThreadRepository.get(jobId);
        return jobThread;
    }

    static {
        jobHandlerRepository = new ConcurrentHashMap<String, IJobHandler>();
        jobThreadRepository = new ConcurrentHashMap<String, JobThread>();
    }
}

