/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.core.thread;

import com.biz.crm.core.biz.AdminBiz;
import com.biz.crm.core.biz.model.RegistryParam;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.enums.RegistryConfig;
import com.biz.crm.core.executor.XxlJobExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRegistryThread {
    private static Logger logger = LoggerFactory.getLogger(ExecutorRegistryThread.class);
    private static ExecutorRegistryThread instance = new ExecutorRegistryThread();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static ExecutorRegistryThread getInstance() {
        return instance;
    }

    public void start(final String appname, final String address) {
        if (appname == null || appname.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, appname is null.");
            return;
        }
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> xxl-job, executor registry config fail, adminAddresses is null.");
            return;
        }
        this.registryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block16: {
                    ReturnT<String> registryResult;
                    RegistryParam registryParam;
                    while (!ExecutorRegistryThread.this.toStop) {
                        block15: {
                            try {
                                registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appname, address);
                                for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                                    try {
                                        registryResult = adminBiz.registry(registryParam);
                                        if (registryResult != null && 200 == registryResult.getCode()) {
                                            registryResult = ReturnT.SUCCESS;
                                            logger.debug(">>>>>>>>>>> xxl-job registry success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                            break;
                                        }
                                        logger.info(">>>>>>>>>>> xxl-job registry fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    }
                                    catch (Exception e) {
                                        logger.info(">>>>>>>>>>> xxl-job registry error, registryParam:{}", (Object)registryParam, (Object)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ExecutorRegistryThread.this.toStop) break block15;
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            if (ExecutorRegistryThread.this.toStop) continue;
                            TimeUnit.SECONDS.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            if (ExecutorRegistryThread.this.toStop) continue;
                            logger.warn(">>>>>>>>>>> xxl-job, executor registry thread interrupted, error msg:{}", (Object)e.getMessage());
                        }
                    }
                    try {
                        registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appname, address);
                        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                            try {
                                registryResult = adminBiz.registryRemove(registryParam);
                                if (registryResult != null && 200 == registryResult.getCode()) {
                                    registryResult = ReturnT.SUCCESS;
                                    logger.info(">>>>>>>>>>> xxl-job registry-remove success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    break;
                                }
                                logger.info(">>>>>>>>>>> xxl-job registry-remove fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                            }
                            catch (Exception e) {
                                if (ExecutorRegistryThread.this.toStop) continue;
                                logger.info(">>>>>>>>>>> xxl-job registry-remove error, registryParam:{}", (Object)registryParam, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ExecutorRegistryThread.this.toStop) break block16;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, executor registry thread destory.");
            }
        });
        this.registryThread.setDaemon(true);
        this.registryThread.setName("xxl-job, executor ExecutorRegistryThread");
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryThread.interrupt();
        try {
            this.registryThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

