package com.biz.crm.admin.controller;

import com.biz.crm.admin.controller.annotation.PermissionLimit;
import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.service.JobService;
import com.biz.crm.core.biz.AdminBiz;
import com.biz.crm.core.biz.model.HandleCallbackParam;
import com.biz.crm.core.biz.model.RegistryParam;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.util.GsonTool;
import com.biz.crm.nebular.job.req.XxlJobLogReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by xuxueli on 17/5/10.
 */
@Controller
@RequestMapping("/api")
@Api(tags = "定时任务通用")
public class JobApiController {

    @Resource
    private AdminBiz adminBiz;

    @Resource
    private JobService jobService;

    /**
     * api
     *
     * @param uri
     * @param data
     * @return
     */
    @RequestMapping("/{uri}")
    @ResponseBody
    @PermissionLimit(limit = false)
    public ReturnT<String> api(HttpServletRequest request, @PathVariable("uri") String uri, @RequestBody(required = false) String data) {

        // valid
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return new ReturnT<String>(ReturnT.FAIL_CODE, "invalid request, HttpMethod not support.");
        }
        if (uri == null || uri.trim().length() == 0) {
            return new ReturnT<String>(ReturnT.FAIL_CODE, "invalid request, uri-mapping empty.");
        }
//        if (XxlJobAdminConfig.getAdminConfig().getAccessToken() != null
//                && XxlJobAdminConfig.getAdminConfig().getAccessToken().trim().length() > 0
//                && !XxlJobAdminConfig.getAdminConfig().getAccessToken().equals(request.getHeader(XxlJobRemotingUtil.XXL_JOB_ACCESS_TOKEN))) {
//            return new ReturnT<String>(ReturnT.FAIL_CODE, "The access token is wrong.");
//        }

        // services mapping
        if ("callback".equals(uri)) {
            List<HandleCallbackParam> callbackParamList = GsonTool.fromJson(data, List.class, HandleCallbackParam.class);
            return adminBiz.callback(callbackParamList);
        } else if ("registry".equals(uri)) {
            RegistryParam registryParam = GsonTool.fromJson(data, RegistryParam.class);
            return adminBiz.registry(registryParam);
        } else if ("registryRemove".equals(uri)) {
            RegistryParam registryParam = GsonTool.fromJson(data, RegistryParam.class);
            return adminBiz.registryRemove(registryParam);
        } else {
            return new ReturnT<String>(ReturnT.FAIL_CODE, "invalid request, uri-mapping(" + uri + ") not found.");
        }

    }

    @PostMapping("/getJobConfig")
    @ResponseBody
    @ApiOperation("获取编辑框配置")
    public Result getJobConfig(@RequestBody XxlJobLogReqVo xxlJobLogReqVo) {

        return Result.ok(jobService.configValue(xxlJobLogReqVo.getConfigKey()));

    }

}
