package com.biz.crm.admin.controller;

import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLogGlue;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.mapper.XxlJobInfoDao;
import com.biz.crm.admin.mapper.XxlJobLogGlueDao;
import com.biz.crm.core.glue.GlueTypeEnum;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * job code controller
 *
 * @author xuxueli 2015-12-19 16:13:16
 */
@Controller
@RequestMapping("/jobcode")
@Api(value = "任务代码类")
public class JobCodeController {

    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;

    public String index(HttpServletRequest request, Model model, String jobId) {
        XxlJobInfo jobInfo = xxlJobInfoDao.loadById(jobId);
        List<XxlJobLogGlue> jobLogGlues = xxlJobLogGlueDao.findByJobId(jobId);

        if (jobInfo == null) {
            throw new RuntimeException(I18nUtil.getString("jobinfo_glue_jobid_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match(jobInfo.getGlueType())) {
            throw new RuntimeException(I18nUtil.getString("jobinfo_glue_gluetype_unvalid"));
        }

        // valid permission
        JobInfoController.validPermission(request, jobInfo.getJobGroup());

        // Glue类型-字典
        model.addAttribute("GlueTypeEnum", GlueTypeEnum.values());

        model.addAttribute("jobInfo", jobInfo);
        model.addAttribute("jobLogGlues", jobLogGlues);
        return "jobcode/jobcode.index";
    }

    @PostMapping("/getLogGlue")
    @ResponseBody
    @ApiOperation("获取定时任务规则")
    public Result<List<XxlJobLogGlue>> getLogGlue(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotNull(vo.getJobCode(), "任务码不能为空！");
        return Result.ok(xxlJobLogGlueDao.findByJobId(vo.getJobCode()));
    }

    @PostMapping("/save")
    @ResponseBody
    @ApiOperation("保存定时任务规则")
    public Result save(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotEmpty(vo.getGlueRemark(), "版本备注不能为空！");
        XxlJobInfo exists_jobInfo = xxlJobInfoDao.loadById(vo.getJobCode());
        AssertUtils.isNotNull(exists_jobInfo, "该id非法！");

        // update new code
        exists_jobInfo.setGlueSource(vo.getGlueSource());
        exists_jobInfo.setGlueRemark(vo.getGlueRemark());
        exists_jobInfo.setGlueUpdatetime(new Date());

        exists_jobInfo.setUpdateTime(new Date());
        xxlJobInfoDao.updateById(exists_jobInfo);

        // log old code
        XxlJobLogGlue xxlJobLogGlue = new XxlJobLogGlue();
        xxlJobLogGlue.setJobId(exists_jobInfo.getId());
        xxlJobLogGlue.setGlueType(exists_jobInfo.getGlueType());
        xxlJobLogGlue.setGlueSource(vo.getGlueSource());
        xxlJobLogGlue.setGlueRemark(vo.getGlueRemark());

        xxlJobLogGlue.setAddTime(new Date());
        xxlJobLogGlue.setUpdateTime(new Date());
        //xxlJobLogGlueDao.save(xxlJobLogGlue);
        xxlJobLogGlueDao.insert(xxlJobLogGlue);

        // remove code backup more than 30
        //xxlJobLogGlueDao.removeOld(exists_jobInfo.getId(), 30);

        return Result.ok();
    }

}
