package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * xxl-job info
 *
 * @author xuxueli  2016-1-12 18:25:49
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_info")
@CrmTable(name = "xxl_job_info",tableNote = "job-任务")
public class XxlJobInfo extends BaseIdEntity {

	@ApiModelProperty("执行器ID")
	@CrmColumn(name = "job_group", length = 64,note = "执行器id")
	private String jobGroup;

	@ApiModelProperty("任务描述")
	@CrmColumn(name = "job_desc", length = 256,note = "任务描述")
	private String jobDesc;

	@ApiModelProperty("添加时间")
	@CrmColumn(name = "add_time",note = "添加时间")
	private Date addTime;

	@ApiModelProperty("更新时间")
	@CrmColumn(name = "update_time", note = "更新时间")
	private Date updateTime;

	@ApiModelProperty("负责人")
	@CrmColumn(name = "author", length = 64,note = "负责人")
	private String author;

	@ApiModelProperty("报警邮件")
	@CrmColumn(name = "alarm_email", length = 64,note = "报警邮件")
	private String alarmEmail;

	@ApiModelProperty("调度类型")
	@CrmColumn(name = "schedule_type", length = 20,note = "调度类型")
	private String scheduleType;

	@ApiModelProperty("调度配置，值含义取决于调度类型")
	@CrmColumn(name = "schedule_conf", length = 64,note = "调度配置")
	private String scheduleConf;

	@ApiModelProperty("调度过期策略")
	@CrmColumn(name = "misfire_strategy", length = 64,note = "调度过期策略")
	private String misfireStrategy;

	@ApiModelProperty("执行器路由策略")
	@CrmColumn(name = "executor_route_strategy", length = 64,note = "执行器路由策略")
	private String executorRouteStrategy;

	@ApiModelProperty("执行器，任务Handler名称")
	@CrmColumn(name = "executor_handler", length = 64,note = "执行器handler名称")
	private String executorHandler;

	@ApiModelProperty("执行器，任务参数")
	@CrmColumn(name = "executor_param", length = 255,note = "任务参数")
	private String executorParam;

	@ApiModelProperty("阻塞处理策略")
	@CrmColumn(name = "executor_block_strategy", length = 64,note = "阻塞处理策略")
	private String executorBlockStrategy;

	@ApiModelProperty("任务执行超时时间，单位秒")
	@CrmColumn(name = "executor_timeout", length = 10,note = "超时时间")
	private int executorTimeout;

	@ApiModelProperty("失败重试次数")
	@CrmColumn(name = "executor_fail_retry_count", length = 10,note = "重试次数")
	private int executorFailRetryCount;

	@ApiModelProperty("GLUE类型,com.xxl.job.core.glue.GlueTypeEnum")
	@CrmColumn(name = "glue_type", length = 24,note = "glue类型")
	private String glueType;

	@ApiModelProperty("GLUE源代码")
	@CrmColumn(name = "glue_source", length = 4000,note = "glue代码")
	private String glueSource;

	@ApiModelProperty("GLUE备注")
	@CrmColumn(name = "glue_remark", length = 255,note = "glue备注")
	private String glueRemark;

	@ApiModelProperty("GLUE更新时间")
	@CrmColumn(name = "glue_updatetime", note = "glue更新时间")
	private Date glueUpdatetime;

	@ApiModelProperty("子任务ID，多个逗号分隔")
	@CrmColumn(name = "child_job_id", length = 255,note = "子任务id")
	private String childJobId;

	@ApiModelProperty("调度状态：0-停止，1-运行")
	@CrmColumn(name = "trigger_status", length = 2,note = "调度状态：0-停止，1-运行")
	private int triggerStatus;

	@ApiModelProperty("上次调度时间")
	@CrmColumn(name = "trigger_last_time", length = 38,note = "上次调度时间")
	private long triggerLastTime;

	@ApiModelProperty("下次调度时间")
	@CrmColumn(name = "trigger_next_time", length = 38,note = "下次调度时间")
	private long triggerNextTime;

	@ApiModelProperty("调度状态值")
	@CrmColumn(name = "trigger_status_value", length = 64,note = "调度状态值")
	private String triggerStatusValue;

}
