package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_log_report")
@CrmTable(name = "xxl_job_log_report",tableNote = "job-日志统计")
public class XxlJobLogReport extends BaseIdEntity {

    @CrmColumn(name = "trigger_day", note = "调度时间")
    private Date triggerDay;

    @CrmColumn(name = "running_count", length = 38,note = "执行次数")
    private int runningCount;

    @CrmColumn(name = "suc_count", length = 38,note = "成功次数")
    private int sucCount;

    @CrmColumn(name = "fail_count", length = 38,note = "失败次数")
    private int failCount;


}
