package com.biz.crm.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.nebular.job.req.XxlJobLogReqVo;
import com.biz.crm.nebular.job.resp.XxlJobLogRespVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * job log
 *
 * @author xuxueli 2016-1-12 18:03:06
 */
@Mapper
public interface XxlJobLogDao  extends BaseMapper<XxlJobLog> {

    // exist jobId not use jobGroup, not exist use jobGroup
    public List<XxlJobLogRespVo> pageList(Page<XxlJobLogRespVo> page, @Param("vo") XxlJobLogReqVo vo);

    public int pageListCount(@Param("offset") int offset,
                             @Param("pagesize") int pagesize,
                             @Param("jobGroup") int jobGroup,
                             @Param("jobId") String jobId,
                             @Param("triggerTimeStart") Date triggerTimeStart,
                             @Param("triggerTimeEnd") Date triggerTimeEnd,
                             @Param("logStatus") int logStatus);

    public XxlJobLog load(@Param("id") String id);

    public long save(XxlJobLog xxlJobLog);
//
//    public int updateTriggerInfo(XxlJobLog xxlJobLog);
//
//    public int updateHandleInfo(XxlJobLog xxlJobLog);

    public int delete(@Param("jobId") String jobId);

    public Map<String, Object> findLogReport(@Param("from") Date from,
                                             @Param("to") Date to);

    public List<String> findClearLogIds(@Param("jobGroup") String jobGroup,
                                      @Param("jobId") String jobId,
                                      @Param("clearBeforeTime") Date clearBeforeTime,
                                      @Param("page") Page<String> page);

    public int clearLog(@Param("logIds") List<String> logIds);

    public List<String> findFailJobLogIds(Page<Long> page);

    public int updateAlarmStatus(@Param("logId") String logId,
                                 @Param("oldAlarmStatus") int oldAlarmStatus,
                                 @Param("newAlarmStatus") int newAlarmStatus);

    public List<String> findLostJobIds(@Param("losedTime") Date losedTime);

}
