package com.biz.crm.admin.service;


import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.common.PageResult;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.nebular.job.req.JobChartInfoReqVo;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.job.resp.JobChartInfoInfoRespVo;
import com.biz.crm.nebular.job.resp.JobStatisticsInfoRespVo;

import java.util.List;

/**
 * core job action for xxl-job
 * 
 * @author xuxueli 2016-5-28 15:30:33
 */
public interface XxlJobService {

	/**
	 * page list
	 *
	 * @param xxlJobInfoReqVo
	 * @return
	 */
	public PageResult<XxlJobInfo> pageList(XxlJobInfoReqVo xxlJobInfoReqVo);


	/**
	 * page list
	 *
	 * @param id 任务ID
	 * @return
	 */
	public XxlJobInfo query(String id);

	/**
	 * add job
	 *
	 * @param jobInfo
	 * @return
	 */
	public XxlJobInfo add(XxlJobInfo jobInfo);

	/**
	 * update job
	 *
	 * @param jobInfo
	 * @return
	 */
	public ReturnT<String> update(XxlJobInfo jobInfo);

	/**
	 * remove job
	 * 	 *
	 * @param id
	 * @return
	 */
	public void remove(List<String> ids);

	/**
	 * start job
	 *
	 * @param id
	 * @return
	 */
	public ReturnT<String> start(String id);

	/**
	 * stop job
	 *
	 * @param id
	 * @return
	 */
	public ReturnT<String> stop(String id);

	/**
	 * 统计信息
	 *
	 * @return
	 */
	public JobStatisticsInfoRespVo statisticsInfo();

	/**
	 * chart info
	 *
	 * @param reqVo
	 * @return
	 */
	public JobChartInfoInfoRespVo chartInfo(JobChartInfoReqVo reqVo);

	void test();
}
