package com.biz.crm.executor.jobhandler;

import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.handler.annotation.XxlJob;
import com.biz.crm.mdm.newhope.NewHopeOrgSyncFeign;
import com.biz.crm.mdm.newhope.NewHopeUserSyncFeign;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.util.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author maoshen
 * @date 2021/6/11.
 */
@Component
public class NewHopeXxlJob {
    private static Logger logger = LoggerFactory.getLogger(NewHopeXxlJob.class);

    @Resource
    private NewHopeOrgSyncFeign orgSyncFeign;

    @Resource
    private NewHopeUserSyncFeign userSyncFeign;

    /**
     * 组织全量
     */
    @XxlJob("orgSyncAllJobHandler")
    public ReturnT<String> orgSyncAllJobHandler(String param) throws Exception {
        UserUtils.doTokenForNull();
        logger.info("组织全量");
        orgSyncFeign.orgSyncAll(new NewHopeReqVo());
        return ReturnT.SUCCESS;
    }

    /**
     * 组织增量
     */
    @XxlJob("orgSyncIncrementJobHandler")
    public ReturnT<String> orgSyncIncrementJobHandler(String param) throws Exception {
        UserUtils.doTokenForNull();
        logger.info("组织增量");
        orgSyncFeign.orgSyncIncrement(new NewHopeReqVo());
        return ReturnT.SUCCESS;
    }

    /**
     * 用户全量
     */
    @XxlJob("userSyncAllJobHandler")
    public ReturnT<String> userSyncAllJobHandler(String param) throws Exception {
        UserUtils.doTokenForNull();
        logger.info("用户全量");
        userSyncFeign.userSyncAll(new NewHopeReqVo());
        return ReturnT.SUCCESS;
    }

    /**
     * 用户增量
     */
    @XxlJob("userSyncIncrementJobHandler")
    public ReturnT<String> userSyncIncrementJobHandler(String param) throws Exception {
        UserUtils.doTokenForNull();
        logger.info("组织增加量");
        userSyncFeign.userSyncIncrement(new NewHopeReqVo());
        return ReturnT.SUCCESS;
    }

}
