package com.biz.crm.executor.jobhandler;

import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.handler.annotation.XxlJob;
import com.biz.crm.core.xxllog.XxlJobLogger;
import com.biz.crm.sfa.sfajob.SfaJobFeign;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.executor.jobhandler.sfajob
 * @date 2021/7/30 17:11
 */
@Component
public class SfaXxlJob {


    @Resource
    private SfaJobFeign sfaJobFeign;


    /**
     * 拜访计划结算任务
     *
     * @return
     */
    @XxlJob("visitPlanInfoSettlementDoJob")
    public ReturnT<String> visitPlanInfoSettlementDoJob(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,拜访计划结算任务=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.visitPlanInfoSettlementDoJob();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,拜访计划结算任务=============>>执行失败:" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 拜访日进度结算任务开始
     *
     * @return
     */
    @XxlJob("planInfoSettlementForJob")
    public ReturnT<String> planInfoSettlementForJob(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,拜访日进度结算任务开始=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.planInfoSettlementForJob();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,拜访日进度结算任务开始=============>>执行失败:" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 任务过期定时任务
     *
     * @return
     */
    @XxlJob("executeWorkSignRule")
    public ReturnT<String> executeWorkSignRule(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,任务过期定时任务=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.executeWorkSignRule();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,任务过期定时任务=============>>执行失败:" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 每月定时拉取职位增加积分
     *
     * @return
     */
    @XxlJob("saveIntegralDetailByMonth")
    public ReturnT<String> saveIntegralDetailByMonth(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,每月定时拉取职位增加积分=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.saveIntegralDetailByMonth();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,每月定时拉取职位增加积分=============>>执行失败：" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 活动执行明细解析任务 每天3点30分执行任务
     *
     * @return
     */
    @XxlJob("resolveSfaVisitActivityExecute")
    public ReturnT<String> resolveSfaVisitActivityExecute(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,解析活动明细任务=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.resolveSfaVisitActivityExecute();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,解析活动明细任务=============>>执行失败：" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 解析拜访计划生成明细
     *
     * @param param
     * @return
     * @throws Exception
     */
    @XxlJob("executeSfaVisitPlan")
    public ReturnT<String> executeSfaVisitPlan(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB,解析拜访计划生成明细=============>>开始执行");
        UserUtils.doTokenForNull();
        Result result = sfaJobFeign.executeSfaVisitPlan();
        if (!result.isSuccess()) {
            XxlJobLogger.log("XXL-JOB,解析拜访计划生成明细=============>>执行失败：" + result.getMessage());
        }
        return ReturnT.SUCCESS;
    }

}
