/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.context;

import com.biz.crm.admin.core.context.XxlJobContext;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.util.DateUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class XxlJobHelper {
    private static Logger logger = LoggerFactory.getLogger((String)"xxl-job logger");

    public static long getJobId() {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return -1L;
        }
        return xxlJobContext.getJobId();
    }

    public static String getJobParam() {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return null;
        }
        return xxlJobContext.getJobParam();
    }

    public static String getJobLogFileName() {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return null;
        }
        return xxlJobContext.getJobLogFileName();
    }

    public static int getShardIndex() {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return -1;
        }
        return xxlJobContext.getShardIndex();
    }

    public static int getShardTotal() {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return -1;
        }
        return xxlJobContext.getShardTotal();
    }

    public static boolean log(String appendLogPattern, Object ... appendLogArguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)appendLogPattern, (Object[])appendLogArguments);
        String appendLog = ft.getMessage();
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        return XxlJobHelper.logDetail(callInfo, appendLog);
    }

    public static boolean log(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String appendLog = stringWriter.toString();
        StackTraceElement callInfo = new Throwable().getStackTrace()[1];
        return XxlJobHelper.logDetail(callInfo, appendLog);
    }

    private static boolean logDetail(StackTraceElement callInfo, String appendLog) {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DateUtil.formatDateTime((Date)new Date())).append(" ").append("[" + callInfo.getClassName() + "#" + callInfo.getMethodName() + "]").append("-").append("[" + callInfo.getLineNumber() + "]").append("-").append("[" + Thread.currentThread().getName() + "]").append(" ").append(appendLog != null ? appendLog : "");
        String formatAppendLog = stringBuffer.toString();
        String logFileName = xxlJobContext.getJobLogFileName();
        if (logFileName != null && logFileName.trim().length() > 0) {
            XxlJobFileAppender.appendLog((String)logFileName, (String)formatAppendLog);
            return true;
        }
        logger.info(">>>>>>>>>>> {}", (Object)formatAppendLog);
        return false;
    }

    public static boolean handleSuccess() {
        return XxlJobHelper.handleResult(200, null);
    }

    public static boolean handleSuccess(String handleMsg) {
        return XxlJobHelper.handleResult(200, handleMsg);
    }

    public static boolean handleFail() {
        return XxlJobHelper.handleResult(500, null);
    }

    public static boolean handleFail(String handleMsg) {
        return XxlJobHelper.handleResult(500, handleMsg);
    }

    public static boolean handleTimeout() {
        return XxlJobHelper.handleResult(502, null);
    }

    public static boolean handleTimeout(String handleMsg) {
        return XxlJobHelper.handleResult(502, handleMsg);
    }

    public static boolean handleResult(int handleCode, String handleMsg) {
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        if (xxlJobContext == null) {
            return false;
        }
        xxlJobContext.setHandleCode(handleCode);
        if (handleMsg != null) {
            xxlJobContext.setHandleMsg(handleMsg);
        }
        return true;
    }
}

