/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.cron.CronExpression;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLogReport;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobScheduleHelper;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobLogDao;
import com.biz.crm.admin.dao.XxlJobLogGlueDao;
import com.biz.crm.admin.dao.XxlJobLogReportDao;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.PageUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static Logger logger = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;
    @Resource
    private XxlJobLogReportDao xxlJobLogReportDao;

    @Override
    public PageResult<XxlJobInfo> pageList(XxlJobInfoReqVo xxlJobInfoReqVo) {
        Page page = PageUtil.buildPage((Integer)xxlJobInfoReqVo.getPageNum(), (Integer)xxlJobInfoReqVo.getPageSize());
        List<XxlJobInfo> list = this.xxlJobInfoDao.pageList((Page<XxlJobInfo>)page, xxlJobInfoReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        XxlJobGroup group = this.xxlJobGroupDao.load(jobInfo.getJobGroup());
        if (group == null) {
            return new ReturnT(500, I18nUtil.getString("system_please_choose") + I18nUtil.getString("jobinfo_field_jobgroup"));
        }
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_author"));
        }
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(jobInfo.getScheduleType(), null);
        if (scheduleTypeEnum == null) {
            return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
        }
        if (scheduleTypeEnum == ScheduleTypeEnum.CRON) {
            if (jobInfo.getScheduleConf() == null || !CronExpression.isValidExpression(jobInfo.getScheduleConf())) {
                return new ReturnT(500, "Cron" + I18nUtil.getString("system_unvalid"));
            }
        } else if (scheduleTypeEnum == ScheduleTypeEnum.FIX_RATE) {
            if (jobInfo.getScheduleConf() == null) {
                return new ReturnT(500, I18nUtil.getString("schedule_type"));
            }
            try {
                int fixSecond = Integer.valueOf(jobInfo.getScheduleConf());
                if (fixSecond < 1) {
                    return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
                }
            }
            catch (Exception e) {
                return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
            }
        }
        if (GlueTypeEnum.match((String)jobInfo.getGlueType()) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_gluetype") + I18nUtil.getString("system_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match((String)jobInfo.getGlueType()) && (jobInfo.getExecutorHandler() == null || jobInfo.getExecutorHandler().trim().length() == 0)) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "JobHandler");
        }
        if (GlueTypeEnum.GLUE_SHELL == GlueTypeEnum.match((String)jobInfo.getGlueType()) && jobInfo.getGlueSource() != null) {
            jobInfo.setGlueSource(jobInfo.getGlueSource().replaceAll("\r", ""));
        }
        if (ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorRouteStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (MisfireStrategyEnum.match(jobInfo.getMisfireStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("misfire_strategy") + I18nUtil.getString("system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorBlockStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        jobInfo.setAddTime(new Date());
        jobInfo.setUpdateTime(new Date());
        jobInfo.setGlueUpdatetime(new Date());
        this.xxlJobInfoDao.save(jobInfo);
        if (jobInfo.getId() < 1) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_add") + I18nUtil.getString("system_fail"));
        }
        return new ReturnT((Object)String.valueOf(jobInfo.getId()));
    }

    private boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        boolean scheduleDataNotChanged;
        XxlJobGroup jobGroup;
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_author"));
        }
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(jobInfo.getScheduleType(), null);
        if (scheduleTypeEnum == null) {
            return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
        }
        if (scheduleTypeEnum == ScheduleTypeEnum.CRON) {
            if (jobInfo.getScheduleConf() == null || !CronExpression.isValidExpression(jobInfo.getScheduleConf())) {
                return new ReturnT(500, "Cron" + I18nUtil.getString("system_unvalid"));
            }
        } else if (scheduleTypeEnum == ScheduleTypeEnum.FIX_RATE) {
            if (jobInfo.getScheduleConf() == null) {
                return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
            }
            try {
                int fixSecond = Integer.valueOf(jobInfo.getScheduleConf());
                if (fixSecond < 1) {
                    return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
                }
            }
            catch (Exception e) {
                return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
            }
        }
        if (ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorRouteStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (MisfireStrategyEnum.match(jobInfo.getMisfireStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("misfire_strategy") + I18nUtil.getString("system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorBlockStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        if ((jobGroup = this.xxlJobGroupDao.load(jobInfo.getJobGroup())) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_jobgroup") + I18nUtil.getString("system_unvalid"));
        }
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(jobInfo.getId());
        if (exists_jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_id") + I18nUtil.getString("system_not_found"));
        }
        long nextTriggerTime = exists_jobInfo.getTriggerNextTime();
        boolean bl = scheduleDataNotChanged = jobInfo.getScheduleType().equals(exists_jobInfo.getScheduleType()) && jobInfo.getScheduleConf().equals(exists_jobInfo.getScheduleConf());
        if (exists_jobInfo.getTriggerStatus() == 1 && !scheduleDataNotChanged) {
            try {
                Date nextValidTime = JobScheduleHelper.generateNextValidTime(jobInfo, new Date(System.currentTimeMillis() + 5000L));
                if (nextValidTime == null) {
                    return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
                }
                nextTriggerTime = nextValidTime.getTime();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
            }
        }
        exists_jobInfo.setJobGroup(jobInfo.getJobGroup());
        exists_jobInfo.setJobDesc(jobInfo.getJobDesc());
        exists_jobInfo.setAuthor(jobInfo.getAuthor());
        exists_jobInfo.setAlarmEmail(jobInfo.getAlarmEmail());
        exists_jobInfo.setScheduleType(jobInfo.getScheduleType());
        exists_jobInfo.setScheduleConf(jobInfo.getScheduleConf());
        exists_jobInfo.setMisfireStrategy(jobInfo.getMisfireStrategy());
        exists_jobInfo.setExecutorRouteStrategy(jobInfo.getExecutorRouteStrategy());
        exists_jobInfo.setExecutorHandler(jobInfo.getExecutorHandler());
        exists_jobInfo.setExecutorParam(jobInfo.getExecutorParam());
        exists_jobInfo.setExecutorBlockStrategy(jobInfo.getExecutorBlockStrategy());
        exists_jobInfo.setExecutorTimeout(jobInfo.getExecutorTimeout());
        exists_jobInfo.setExecutorFailRetryCount(jobInfo.getExecutorFailRetryCount());
        exists_jobInfo.setChildJobId(jobInfo.getChildJobId());
        exists_jobInfo.setTriggerNextTime(nextTriggerTime);
        exists_jobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(exists_jobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    @Transactional
    public void remove(List<String> ids) {
        ids.forEach(id -> {
            XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(id));
            if (xxlJobInfo != null) {
                this.xxlJobInfoDao.delete(Long.parseLong(id));
                this.xxlJobLogDao.delete(Integer.parseInt(id));
                this.xxlJobLogGlueDao.deleteByJobId(Integer.parseInt(id));
            }
        });
    }

    @Override
    public ReturnT<String> start(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(xxlJobInfo.getScheduleType(), ScheduleTypeEnum.NONE);
        if (ScheduleTypeEnum.NONE == scheduleTypeEnum) {
            return new ReturnT(500, I18nUtil.getString("schedule_type_none_limit_start"));
        }
        long nextTriggerTime = 0L;
        try {
            Date nextValidTime = JobScheduleHelper.generateNextValidTime(xxlJobInfo, new Date(System.currentTimeMillis() + 5000L));
            if (nextValidTime == null) {
                return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
            }
            nextTriggerTime = nextValidTime.getTime();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid"));
        }
        xxlJobInfo.setTriggerStatus(1);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(nextTriggerTime);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    public ReturnT<String> stop(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        xxlJobInfo.setTriggerStatus(0);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(0L);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    public Map<String, Object> dashboardInfo() {
        int jobInfoCount = this.xxlJobInfoDao.findAllCount();
        int jobLogCount = 0;
        int jobLogSuccessCount = 0;
        XxlJobLogReport xxlJobLogReport = this.xxlJobLogReportDao.queryLogReportTotal();
        if (xxlJobLogReport != null) {
            jobLogCount = xxlJobLogReport.getRunningCount() + xxlJobLogReport.getSucCount() + xxlJobLogReport.getFailCount();
            jobLogSuccessCount = xxlJobLogReport.getSucCount();
        }
        HashSet<String> executorAddressSet = new HashSet<String>();
        List<XxlJobGroup> groupList = this.xxlJobGroupDao.findAll();
        if (groupList != null && !groupList.isEmpty()) {
            for (XxlJobGroup group : groupList) {
                if (group.getRegistryList() == null || group.getRegistryList().isEmpty()) continue;
                executorAddressSet.addAll(group.getRegistryList());
            }
        }
        int executorCount = executorAddressSet.size();
        HashMap<String, Object> dashboardMap = new HashMap<String, Object>();
        dashboardMap.put("jobInfoCount", jobInfoCount);
        dashboardMap.put("jobLogCount", jobLogCount);
        dashboardMap.put("jobLogSuccessCount", jobLogSuccessCount);
        dashboardMap.put("executorCount", executorCount);
        return dashboardMap;
    }

    @Override
    public ReturnT<Map<String, Object>> chartInfo(Date startDate, Date endDate) {
        ArrayList<String> triggerDayList = new ArrayList<String>();
        ArrayList<Integer> triggerDayCountRunningList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountSucList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountFailList = new ArrayList<Integer>();
        int triggerCountRunningTotal = 0;
        int triggerCountSucTotal = 0;
        int triggerCountFailTotal = 0;
        List<XxlJobLogReport> logReportList = this.xxlJobLogReportDao.queryLogReport(startDate, endDate);
        if (logReportList != null && logReportList.size() > 0) {
            for (XxlJobLogReport item : logReportList) {
                String day = DateUtil.formatDate((Date)item.getTriggerDay());
                int triggerDayCountRunning = item.getRunningCount();
                int triggerDayCountSuc = item.getSucCount();
                int triggerDayCountFail = item.getFailCount();
                triggerDayList.add(day);
                triggerDayCountRunningList.add(triggerDayCountRunning);
                triggerDayCountSucList.add(triggerDayCountSuc);
                triggerDayCountFailList.add(triggerDayCountFail);
                triggerCountRunningTotal += triggerDayCountRunning;
                triggerCountSucTotal += triggerDayCountSuc;
                triggerCountFailTotal += triggerDayCountFail;
            }
        } else {
            for (int i = -6; i <= 0; ++i) {
                triggerDayList.add(DateUtil.formatDate((Date)DateUtil.addDays((Date)new Date(), (int)i)));
                triggerDayCountRunningList.add(0);
                triggerDayCountSucList.add(0);
                triggerDayCountFailList.add(0);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("triggerDayList", triggerDayList);
        result.put("triggerDayCountRunningList", triggerDayCountRunningList);
        result.put("triggerDayCountSucList", triggerDayCountSucList);
        result.put("triggerDayCountFailList", triggerDayCountFailList);
        result.put("triggerCountRunningTotal", Integer.valueOf(triggerCountRunningTotal));
        result.put("triggerCountSucTotal", Integer.valueOf(triggerCountSucTotal));
        result.put("triggerCountFailTotal", Integer.valueOf(triggerCountFailTotal));
        return new ReturnT(result);
    }
}

