/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.core.exception.XxlJobException;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobUser;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobScheduleHelper;
import com.biz.crm.admin.core.thread.JobTriggerPoolHelper;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.Result;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobinfo"})
@Api(tags={"\u4efb\u52a1\u7ba1\u7406\u8868;"})
public class JobInfoController {
    private static Logger logger = LoggerFactory.getLogger(JobInfoController.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobService xxlJobService;

    @RequestMapping
    public String index(HttpServletRequest request, Model model, @RequestParam(required=false, defaultValue="-1") int jobGroup) {
        model.addAttribute("ExecutorRouteStrategyEnum", (Object)ExecutorRouteStrategyEnum.values());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("ExecutorBlockStrategyEnum", (Object)ExecutorBlockStrategyEnum.values());
        model.addAttribute("ScheduleTypeEnum", (Object)ScheduleTypeEnum.values());
        model.addAttribute("MisfireStrategyEnum", (Object)MisfireStrategyEnum.values());
        List<XxlJobGroup> jobGroupList_all = this.xxlJobGroupDao.findAll();
        List<XxlJobGroup> jobGroupList = JobInfoController.filterJobGroupByRole(request, jobGroupList_all);
        if (jobGroupList == null || jobGroupList.size() == 0) {
            throw new XxlJobException(I18nUtil.getString("jobgroup_empty"));
        }
        model.addAttribute("JobGroupList", jobGroupList);
        model.addAttribute("jobGroup", (Object)jobGroup);
        return "jobinfo/jobinfo.index";
    }

    public static List<XxlJobGroup> filterJobGroupByRole(HttpServletRequest request, List<XxlJobGroup> jobGroupList_all) {
        List<XxlJobGroup> jobGroupList = new ArrayList<XxlJobGroup>();
        if (jobGroupList_all != null && jobGroupList_all.size() > 0) {
            XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
            if (loginUser.getRole() == 1) {
                jobGroupList = jobGroupList_all;
            } else {
                List<Object> groupIdStrs = new ArrayList();
                if (loginUser.getPermission() != null && loginUser.getPermission().trim().length() > 0) {
                    groupIdStrs = Arrays.asList(loginUser.getPermission().trim().split(","));
                }
                for (XxlJobGroup groupItem : jobGroupList_all) {
                    if (!groupIdStrs.contains(String.valueOf(groupItem.getId()))) continue;
                    jobGroupList.add(groupItem);
                }
            }
        }
        return jobGroupList;
    }

    public static void validPermission(HttpServletRequest request, int jobGroup) {
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        if (!loginUser.validPermission(jobGroup)) {
            throw new RuntimeException(I18nUtil.getString("system_permission_limit") + "[username=" + loginUser.getUsername() + "]");
        }
    }

    @PostMapping(value={"/pageList"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public Result<PageResult<XxlJobInfo>> pageList(@RequestBody XxlJobInfoReqVo xxlJobInfoReqVo) {
        return Result.ok(this.xxlJobService.pageList(xxlJobInfoReqVo));
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1")
    public Result add(XxlJobInfo jobInfo) {
        this.xxlJobService.add(jobInfo);
        return Result.ok();
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u4efb\u52a1")
    public Result update(XxlJobInfo jobInfo) {
        return Result.ok((String)this.xxlJobService.update(jobInfo).getMsg());
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    public Result remove(List<String> ids) {
        this.xxlJobService.remove(ids);
        return Result.ok();
    }

    @GetMapping(value={"/stop"})
    @ResponseBody
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1")
    public Result pause(@RequestParam(value="id", required=true) int id) {
        return Result.ok((String)this.xxlJobService.stop(id).getMsg());
    }

    @GetMapping(value={"/start"})
    @ResponseBody
    @ApiOperation(value="\u5f00\u542f\u4efb\u52a1")
    public Result start(@RequestParam(value="id", required=true) int id) {
        return Result.ok((String)this.xxlJobService.start(id).getMsg());
    }

    @PostMapping(value={"/trigger"})
    @ResponseBody
    @ApiOperation(value="\u89e6\u53d1\u4e00\u6b21\u4efb\u52a1")
    public Result<Object> triggerJob(@RequestBody XxlJobInfoReqVo vo) {
        if (vo.getExecutorParam() == null) {
            vo.setExecutorParam("");
        }
        JobTriggerPoolHelper.trigger(Integer.parseInt(vo.getId()), TriggerTypeEnum.MANUAL, -1, null, vo.getExecutorParam(), vo.getAddressList());
        return Result.ok();
    }

    @PostMapping(value={"/nextTriggerTime"})
    @ResponseBody
    @ApiOperation(value="\u4e0b\u6b21\u6267\u884c\u65f6\u95f4")
    public Result nextTriggerTime(@RequestBody XxlJobInfoReqVo xxlJobInfoReqVo) {
        XxlJobInfo paramXxlJobInfo = new XxlJobInfo();
        paramXxlJobInfo.setScheduleType(xxlJobInfoReqVo.getScheduleType());
        paramXxlJobInfo.setScheduleConf(xxlJobInfoReqVo.getScheduleConf());
        ArrayList<String> result = new ArrayList<String>();
        try {
            Date lastTime = new Date();
            for (int i = 0; i < 5 && (lastTime = JobScheduleHelper.generateNextValidTime(paramXxlJobInfo, lastTime)) != null; ++i) {
                result.add(DateUtil.formatDateTime((Date)lastTime));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Result.error((int)500, (String)(I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid") + e.getMessage()));
        }
        return Result.ok(result);
    }
}

