/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.core.exception.XxlJobException;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobUser;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobScheduleHelper;
import com.biz.crm.admin.core.thread.JobTriggerPoolHelper;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobinfo"})
@Api(tags={"\u4efb\u52a1\u7ba1\u7406\u8868;"})
public class JobInfoController {
    private static Logger logger = LoggerFactory.getLogger(JobInfoController.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobService xxlJobService;

    @RequestMapping
    public String index(HttpServletRequest request, Model model, @RequestParam(required=false, defaultValue="-1") int jobGroup) {
        model.addAttribute("ExecutorRouteStrategyEnum", (Object)ExecutorRouteStrategyEnum.values());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("ExecutorBlockStrategyEnum", (Object)ExecutorBlockStrategyEnum.values());
        model.addAttribute("ScheduleTypeEnum", (Object)ScheduleTypeEnum.values());
        model.addAttribute("MisfireStrategyEnum", (Object)MisfireStrategyEnum.values());
        List<XxlJobGroup> jobGroupList_all = this.xxlJobGroupDao.findAll();
        List<XxlJobGroup> jobGroupList = JobInfoController.filterJobGroupByRole(request, jobGroupList_all);
        if (jobGroupList == null || jobGroupList.size() == 0) {
            throw new XxlJobException(I18nUtil.getString("jobgroup_empty"));
        }
        model.addAttribute("JobGroupList", jobGroupList);
        model.addAttribute("jobGroup", (Object)jobGroup);
        return "jobinfo/jobinfo.index";
    }

    public static List<XxlJobGroup> filterJobGroupByRole(HttpServletRequest request, List<XxlJobGroup> jobGroupList_all) {
        List<XxlJobGroup> jobGroupList = new ArrayList<XxlJobGroup>();
        if (jobGroupList_all != null && jobGroupList_all.size() > 0) {
            XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
            if (loginUser.getRole() == 1) {
                jobGroupList = jobGroupList_all;
            } else {
                List<Object> groupIdStrs = new ArrayList();
                if (loginUser.getPermission() != null && loginUser.getPermission().trim().length() > 0) {
                    groupIdStrs = Arrays.asList(loginUser.getPermission().trim().split(","));
                }
                for (XxlJobGroup groupItem : jobGroupList_all) {
                    if (!groupIdStrs.contains(String.valueOf(groupItem.getId()))) continue;
                    jobGroupList.add(groupItem);
                }
            }
        }
        return jobGroupList;
    }

    public static void validPermission(HttpServletRequest request, int jobGroup) {
        XxlJobUser loginUser = (XxlJobUser)request.getAttribute("XXL_JOB_LOGIN_IDENTITY");
        if (!loginUser.validPermission(jobGroup)) {
            throw new RuntimeException(I18nUtil.getString("system_permission_limit") + "[username=" + loginUser.getUsername() + "]");
        }
    }

    @RequestMapping(value={"/pageList"})
    @ResponseBody
    public Map<String, Object> pageList(@RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, int jobGroup, int triggerStatus, String jobDesc, String executorHandler, String author) {
        return this.xxlJobService.pageList(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        return this.xxlJobService.add(jobInfo);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        return this.xxlJobService.update(jobInfo);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ReturnT<String> remove(int id) {
        return this.xxlJobService.remove(id);
    }

    @RequestMapping(value={"/stop"})
    @ResponseBody
    public ReturnT<String> pause(int id) {
        return this.xxlJobService.stop(id);
    }

    @RequestMapping(value={"/start"})
    @ResponseBody
    public ReturnT<String> start(int id) {
        return this.xxlJobService.start(id);
    }

    @RequestMapping(value={"/trigger"})
    @ResponseBody
    public ReturnT<String> triggerJob(int id, String executorParam, String addressList) {
        if (executorParam == null) {
            executorParam = "";
        }
        JobTriggerPoolHelper.trigger(id, TriggerTypeEnum.MANUAL, -1, null, executorParam, addressList);
        return ReturnT.SUCCESS;
    }

    @RequestMapping(value={"/nextTriggerTime"})
    @ResponseBody
    public ReturnT<List<String>> nextTriggerTime(String scheduleType, String scheduleConf) {
        XxlJobInfo paramXxlJobInfo = new XxlJobInfo();
        paramXxlJobInfo.setScheduleType(scheduleType);
        paramXxlJobInfo.setScheduleConf(scheduleConf);
        ArrayList<String> result = new ArrayList<String>();
        try {
            Date lastTime = new Date();
            for (int i = 0; i < 5 && (lastTime = JobScheduleHelper.generateNextValidTime(paramXxlJobInfo, lastTime)) != null; ++i) {
                result.add(DateUtil.formatDateTime((Date)lastTime));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ReturnT(500, I18nUtil.getString("schedule_type") + I18nUtil.getString("system_unvalid") + e.getMessage());
        }
        return new ReturnT(result);
    }
}

