/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.controller.JobInfoController;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLogGlue;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobLogGlueDao;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.glue.GlueTypeEnum;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobcode"})
public class JobCodeController {
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;

    public String index(HttpServletRequest request, Model model, int jobId) {
        XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(jobId);
        List<XxlJobLogGlue> jobLogGlues = this.xxlJobLogGlueDao.findByJobId(jobId);
        if (jobInfo == null) {
            throw new RuntimeException(I18nUtil.getString("jobinfo_glue_jobid_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match((String)jobInfo.getGlueType())) {
            throw new RuntimeException(I18nUtil.getString("jobinfo_glue_gluetype_unvalid"));
        }
        JobInfoController.validPermission(request, jobInfo.getJobGroup());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("jobInfo", (Object)jobInfo);
        model.addAttribute("jobLogGlues", jobLogGlues);
        return "jobcode/jobcode.index";
    }

    @PostMapping(value={"/getLogGlue"})
    @ResponseBody
    @ApiOperation(value="\u4fdd\u5b58\u5b9a\u65f6\u4efb\u52a1\u89c4\u5219")
    public Result<List<XxlJobLogGlue>> getLogGlue(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotNull((Object)vo.getJobCode(), (String)"\u4efb\u52a1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return Result.ok(this.xxlJobLogGlueDao.findByJobId(Integer.parseInt(vo.getJobCode())));
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @ApiOperation(value="\u4fdd\u5b58\u5b9a\u65f6\u4efb\u52a1\u89c4\u5219")
    public ReturnT<String> save(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotEmpty((String)vo.getGlueRemark(), (String)"\u7248\u672c\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(vo.getId()));
        AssertUtils.isNotNull((Object)exists_jobInfo, (String)"\u8be5id\u975e\u6cd5\uff01");
        exists_jobInfo.setGlueSource(vo.getGlueSource());
        exists_jobInfo.setGlueRemark(vo.getGlueRemark());
        exists_jobInfo.setGlueUpdatetime(new Date());
        exists_jobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(exists_jobInfo);
        XxlJobLogGlue xxlJobLogGlue = new XxlJobLogGlue();
        xxlJobLogGlue.setJobId(exists_jobInfo.getId());
        xxlJobLogGlue.setGlueType(exists_jobInfo.getGlueType());
        xxlJobLogGlue.setGlueSource(vo.getGlueSource());
        xxlJobLogGlue.setGlueRemark(vo.getGlueRemark());
        xxlJobLogGlue.setAddTime(new Date());
        xxlJobLogGlue.setUpdateTime(new Date());
        this.xxlJobLogGlueDao.save(xxlJobLogGlue);
        this.xxlJobLogGlueDao.removeOld(exists_jobInfo.getId(), 30);
        return ReturnT.SUCCESS;
    }
}

