/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.controller.JobInfoController;
import com.biz.crm.admin.core.complete.XxlJobCompleter;
import com.biz.crm.admin.core.context.XxlJobHelper;
import com.biz.crm.admin.core.exception.XxlJobException;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.admin.core.scheduler.XxlJobScheduler;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobLogDao;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.job.req.XxlJobLogReqVo;
import com.biz.crm.nebular.job.resp.XxlJobLogRespVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.KillParam;
import com.xxl.job.core.biz.model.LogParam;
import com.xxl.job.core.biz.model.LogResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/joblog"})
@Api(tags={"\u8c03\u5ea6\u65e5\u5fd7\u8868;"})
public class JobLogController {
    private static Logger logger = LoggerFactory.getLogger(JobLogController.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobHelper xxlJobHelper;

    public String index(HttpServletRequest request, Model model, @RequestParam(required=false, defaultValue="0") Integer jobId) {
        List<XxlJobGroup> jobGroupList_all = this.xxlJobGroupDao.findAll();
        List<XxlJobGroup> jobGroupList = JobInfoController.filterJobGroupByRole(request, jobGroupList_all);
        if (jobGroupList == null || jobGroupList.size() == 0) {
            throw new XxlJobException(I18nUtil.getString("jobgroup_empty"));
        }
        model.addAttribute("JobGroupList", jobGroupList);
        if (jobId > 0) {
            XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(jobId);
            if (jobInfo == null) {
                throw new RuntimeException(I18nUtil.getString("jobinfo_field_id") + I18nUtil.getString("system_unvalid"));
            }
            model.addAttribute("jobInfo", (Object)jobInfo);
            JobInfoController.validPermission(request, jobInfo.getJobGroup());
        }
        return "joblog/joblog.index";
    }

    @PostMapping(value={"/getJobsByGroup"})
    @ResponseBody
    @ApiOperation(value="\u6839\u636e\u6267\u884c\u5668\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public Result<List<XxlJobInfo>> getJobsByGroup(@RequestBody XxlJobLogReqVo vo) {
        List<XxlJobInfo> list = this.xxlJobInfoDao.getJobsByGroup(vo.getJobGroup());
        return Result.ok(list);
    }

    @PostMapping(value={"/pageList"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u8c03\u5ea6\u65e5\u5fd7\u5217\u8868")
    public Result<PageResult<XxlJobLogRespVo>> pageList(@RequestBody XxlJobLogReqVo vo) {
        Page page = PageUtil.buildPage((Integer)vo.getPageNum(), (Integer)vo.getPageSize());
        List<XxlJobLogRespVo> list = this.xxlJobLogDao.pageList((Page<XxlJobLogRespVo>)page, vo);
        return Result.ok((Object)PageResult.builder().data(this.xxlJobHelper.convertJobLog(list)).count(Long.valueOf(page.getTotal())).build());
    }

    @PostMapping(value={"/logDetailCat"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6267\u884c\u65e5\u5fd7")
    public Result logDetailCat(@RequestBody XxlJobLogReqVo vo) {
        try {
            XxlJobLog jobLog;
            ExecutorBiz executorBiz = XxlJobScheduler.getExecutorBiz(vo.getExecutorAddress());
            ReturnT logResult = executorBiz.log(new LogParam(vo.getTriggerTime().getTime(), vo.getLogId().longValue(), vo.getFromLineNum().intValue()));
            if (logResult.getContent() != null && ((LogResult)logResult.getContent()).getFromLineNum() > ((LogResult)logResult.getContent()).getToLineNum() && (jobLog = this.xxlJobLogDao.load(vo.getLogId())).getHandleCode() > 0) {
                ((LogResult)logResult.getContent()).setEnd(true);
            }
            return Result.ok((Object)logResult.getContent());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/logKill"})
    @ResponseBody
    public ReturnT<String> logKill(int id) {
        XxlJobLog log = this.xxlJobLogDao.load(id);
        XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(log.getJobId());
        if (jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_glue_jobid_unvalid"));
        }
        if (200 != log.getTriggerCode()) {
            return new ReturnT(500, I18nUtil.getString("joblog_kill_log_limit"));
        }
        ReturnT runResult = null;
        try {
            ExecutorBiz executorBiz = XxlJobScheduler.getExecutorBiz(log.getExecutorAddress());
            runResult = executorBiz.kill(new KillParam(jobInfo.getId()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            runResult = new ReturnT(500, e.getMessage());
        }
        if (200 == runResult.getCode()) {
            log.setHandleCode(500);
            log.setHandleMsg(I18nUtil.getString("joblog_kill_log_byman") + ":" + (runResult.getMsg() != null ? runResult.getMsg() : ""));
            log.setHandleTime(new Date());
            XxlJobCompleter.updateHandleInfoAndFinish(log);
            return new ReturnT((Object)runResult.getMsg());
        }
        return new ReturnT(500, runResult.getMsg());
    }

    @RequestMapping(value={"/clearLog"})
    @ResponseBody
    public ReturnT<String> clearLog(int jobGroup, int jobId, int type) {
        Date clearBeforeTime = null;
        int clearBeforeNum = 0;
        if (type == 1) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-1);
        } else if (type == 2) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-3);
        } else if (type == 3) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-6);
        } else if (type == 4) {
            clearBeforeTime = DateUtil.addYears((Date)new Date(), (int)-1);
        } else if (type == 5) {
            clearBeforeNum = 1000;
        } else if (type == 6) {
            clearBeforeNum = 10000;
        } else if (type == 7) {
            clearBeforeNum = 30000;
        } else if (type == 8) {
            clearBeforeNum = 100000;
        } else if (type == 9) {
            clearBeforeNum = 0;
        } else {
            return new ReturnT(500, I18nUtil.getString("joblog_clean_type_unvalid"));
        }
        List<Long> logIds = null;
        do {
            if ((logIds = this.xxlJobLogDao.findClearLogIds(jobGroup, jobId, clearBeforeTime, clearBeforeNum, 1000)) == null || logIds.size() <= 0) continue;
            this.xxlJobLogDao.clearLog(logIds);
        } while (logIds != null && logIds.size() > 0);
        return ReturnT.SUCCESS;
    }
}

