/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobRegistry;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobRegistryDao;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.RegistryConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobgroup"})
@Api(tags={"\u6267\u884c\u5668\u7ba1\u7406\u8868;"})
public class JobGroupController {
    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobRegistryDao xxlJobRegistryDao;

    @GetMapping(value={"/pageList"})
    @ResponseBody
    public Map<String, Object> pageList(HttpServletRequest request, @RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, String appname, String title) {
        List<XxlJobGroup> list = this.xxlJobGroupDao.pageList(start, length, appname, title);
        int list_count = this.xxlJobGroupDao.pageListCount(start, length, appname, title);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public ReturnT<String> save(@RequestBody XxlJobGroup xxlJobGroup) {
        if (xxlJobGroup.getAppname() == null || xxlJobGroup.getAppname().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "AppName");
        }
        if (xxlJobGroup.getAppname().length() < 4 || xxlJobGroup.getAppname().length() > 64) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_field_appname_length"));
        }
        if (xxlJobGroup.getAppname().contains(">") || xxlJobGroup.getAppname().contains("<")) {
            return new ReturnT(500, "AppName" + I18nUtil.getString("system_unvalid"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
        }
        if (xxlJobGroup.getTitle().contains(">") || xxlJobGroup.getTitle().contains("<")) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_field_title") + I18nUtil.getString("system_unvalid"));
        }
        if (xxlJobGroup.getAddressType() != 0) {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            if (xxlJobGroup.getAddressList().contains(">") || xxlJobGroup.getAddressList().contains("<")) {
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_registryList") + I18nUtil.getString("system_unvalid"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        xxlJobGroup.setUpdateTime(new Date());
        int ret = this.xxlJobGroupDao.save(xxlJobGroup);
        return ret > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public ReturnT<String> update(@RequestBody XxlJobGroup xxlJobGroup) {
        if (xxlJobGroup.getAppname() == null || xxlJobGroup.getAppname().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "AppName");
        }
        if (xxlJobGroup.getAppname().length() < 4 || xxlJobGroup.getAppname().length() > 64) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_field_appname_length"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
        }
        if (xxlJobGroup.getAddressType() == 0) {
            List<String> registryList = this.findRegistryByAppName(xxlJobGroup.getAppname());
            String addressListStr = null;
            if (registryList != null && !registryList.isEmpty()) {
                Collections.sort(registryList);
                addressListStr = "";
                for (String item : registryList) {
                    addressListStr = addressListStr + item + ",";
                }
                addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
            }
            xxlJobGroup.setAddressList(addressListStr);
        } else {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                return new ReturnT(500, I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        xxlJobGroup.setUpdateTime(new Date());
        int ret = this.xxlJobGroupDao.update(xxlJobGroup);
        return ret > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    private List<String> findRegistryByAppName(String appnameParam) {
        HashMap appAddressMap = new HashMap();
        List<XxlJobRegistry> list = this.xxlJobRegistryDao.findAll(90, new Date());
        if (list != null) {
            for (XxlJobRegistry item : list) {
                if (!RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) continue;
                String appname = item.getRegistryKey();
                ArrayList<String> registryList = (ArrayList<String>)appAddressMap.get(appname);
                if (registryList == null) {
                    registryList = new ArrayList<String>();
                }
                if (!registryList.contains(item.getRegistryValue())) {
                    registryList.add(item.getRegistryValue());
                }
                appAddressMap.put(appname, registryList);
            }
        }
        return (List)appAddressMap.get(appnameParam);
    }

    @GetMapping(value={"/remove"})
    @ResponseBody
    public ReturnT<String> remove(int id) {
        int count = this.xxlJobInfoDao.pageListCount(0, 10, id, -1, null, null, null);
        if (count > 0) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_del_limit_0"));
        }
        List<XxlJobGroup> allList = this.xxlJobGroupDao.findAll();
        if (allList.size() == 1) {
            return new ReturnT(500, I18nUtil.getString("jobgroup_del_limit_1"));
        }
        int ret = this.xxlJobGroupDao.remove(id);
        return ret > 0 ? ReturnT.SUCCESS : ReturnT.FAIL;
    }

    @PostMapping(value={"/loadById"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u5df2\u6ce8\u518c\u8282\u70b9")
    public Result<XxlJobGroup> loadById(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotNull((Object)vo.getId(), (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        XxlJobGroup jobGroup = this.xxlJobGroupDao.load(Integer.parseInt(vo.getId()));
        return Result.ok((Object)jobGroup);
    }

    @PostMapping(value={"/getAllJobGroup"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6267\u884c\u5668\u5217\u8868")
    public Result getJobGroup() {
        return Result.ok(this.xxlJobGroupDao.findAll());
    }
}

