/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.thread;

import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobRegistry;
import com.xxl.job.core.biz.model.RegistryParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.RegistryConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JobRegistryHelper {
    private static Logger logger = LoggerFactory.getLogger(JobRegistryHelper.class);
    private static JobRegistryHelper instance = new JobRegistryHelper();
    private ThreadPoolExecutor registryOrRemoveThreadPool = null;
    private Thread registryMonitorThread;
    private volatile boolean toStop = false;

    public static JobRegistryHelper getInstance() {
        return instance;
    }

    public void start() {
        this.registryOrRemoveThreadPool = new ThreadPoolExecutor(2, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "xxl-job, admin JobRegistryMonitorHelper-registryOrRemoveThreadPool-" + r.hashCode());
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                r.run();
                logger.warn(">>>>>>>>>>> xxl-job, registry or remove too fast, match threadpool rejected handler(run now).");
            }
        });
        this.registryMonitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobRegistryHelper.this.toStop) {
                    block14: {
                        try {
                            List<XxlJobGroup> groupList = XxlJobAdminConfig.getAdminConfig().getXxlJobGroupDao().findByAddressType(0);
                            if (groupList != null && !groupList.isEmpty()) {
                                List<Integer> ids = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().findDead(90, new Date());
                                if (ids != null && ids.size() > 0) {
                                    XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().removeDead(ids);
                                }
                                HashMap appAddressMap = new HashMap();
                                List<XxlJobRegistry> list = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().findAll(90, new Date());
                                if (list != null) {
                                    for (XxlJobRegistry item : list) {
                                        if (!RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) continue;
                                        String appName = item.getRegistryKey();
                                        ArrayList<String> registryList = (ArrayList<String>)appAddressMap.get(appName);
                                        if (registryList == null) {
                                            registryList = new ArrayList<String>();
                                        }
                                        if (!registryList.contains(item.getRegistryValue())) {
                                            registryList.add(item.getRegistryValue());
                                        }
                                        appAddressMap.put(appName, registryList);
                                    }
                                }
                                for (XxlJobGroup group : groupList) {
                                    List registryList = (List)appAddressMap.get(group.getAppName());
                                    String addressListStr = null;
                                    if (registryList != null && !registryList.isEmpty()) {
                                        Collections.sort(registryList);
                                        StringBuilder addressListSB = new StringBuilder();
                                        for (String item : registryList) {
                                            addressListSB.append(item).append(",");
                                        }
                                        addressListStr = addressListSB.toString();
                                        addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
                                    }
                                    group.setAddressList(addressListStr);
                                    group.setUpdateTime(new Date());
                                    XxlJobAdminConfig.getAdminConfig().getXxlJobGroupDao().update(group);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (JobRegistryHelper.this.toStop) break block14;
                            logger.error(">>>>>>>>>>> xxl-job, job registry monitor thread error:{}", (Throwable)e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        if (JobRegistryHelper.this.toStop) continue;
                        logger.error(">>>>>>>>>>> xxl-job, job registry monitor thread error:{}", (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, job registry monitor thread stop");
            }
        });
        this.registryMonitorThread.setDaemon(true);
        this.registryMonitorThread.setName("xxl-job, admin JobRegistryMonitorHelper-registryMonitorThread");
        this.registryMonitorThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryOrRemoveThreadPool.shutdownNow();
        this.registryMonitorThread.interrupt();
        try {
            this.registryMonitorThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public ReturnT<String> registry(final RegistryParam registryParam) {
        if (!(StringUtils.hasText((String)registryParam.getRegistryGroup()) && StringUtils.hasText((String)registryParam.getRegistryKey()) && StringUtils.hasText((String)registryParam.getRegistryValue()))) {
            return new ReturnT(500, "Illegal Argument.");
        }
        this.registryOrRemoveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                int ret = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().registryUpdate(registryParam.getRegistryGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue(), new Date());
                if (ret < 1) {
                    XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().registrySave(registryParam.getRegistryGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue(), new Date());
                    JobRegistryHelper.this.freshGroupRegistryInfo(registryParam);
                }
            }
        });
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> registryRemove(final RegistryParam registryParam) {
        if (!(StringUtils.hasText((String)registryParam.getRegistryGroup()) && StringUtils.hasText((String)registryParam.getRegistryKey()) && StringUtils.hasText((String)registryParam.getRegistryValue()))) {
            return new ReturnT(500, "Illegal Argument.");
        }
        this.registryOrRemoveThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                int ret = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().registryDelete(registryParam.getRegistryGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue());
                if (ret > 0) {
                    JobRegistryHelper.this.freshGroupRegistryInfo(registryParam);
                }
            }
        });
        return ReturnT.SUCCESS;
    }

    private void freshGroupRegistryInfo(RegistryParam registryParam) {
    }
}

