/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller.kms;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobTriggerPoolHelper;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/kms"})
@Api(tags={"KMS\u4efb\u52a1\u7ba1\u7406\u8868;"})
public class KmsJobController {
    @Resource
    private XxlJobService xxlJobService;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;
    private static final String KMS_EXECUTOR = "xxl-job-executor-kms";

    @PostMapping(value={"/add"})
    @ResponseBody
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1")
    public Result add(@RequestBody XxlJobInfoReqVo params) {
        XxlJobInfo jobInfo = (XxlJobInfo)CrmBeanUtil.copy((Object)params, XxlJobInfo.class);
        LambdaQueryWrapper build = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(XxlJobGroup::getAppName, (Object)KMS_EXECUTOR);
        XxlJobGroup xxlJobGroup = (XxlJobGroup)this.xxlJobGroupDao.selectOne((Wrapper)build);
        if (ObjectUtils.isEmpty((Object)xxlJobGroup)) {
            return Result.error((String)"\u6293\u5355\u4efb\u52a1\u6267\u884c\u5668[xxl-job-executor-kms]\u672a\u5efa\u7acb!");
        }
        jobInfo.setJobGroup(xxlJobGroup.getId());
        jobInfo.setScheduleType(ScheduleTypeEnum.CRON.name());
        jobInfo.setGlueType(GlueTypeEnum.BEAN.getDesc());
        jobInfo.setExecutorHandler("kmsJobHandler");
        jobInfo.setExecutorBlockStrategy(ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name());
        jobInfo.setExecutorRouteStrategy(ExecutorRouteStrategyEnum.FIRST.name());
        jobInfo.setMisfireStrategy(MisfireStrategyEnum.DO_NOTHING.name());
        jobInfo.setExecutorTimeout(0);
        jobInfo.setExecutorFailRetryCount(0);
        XxlJobInfo xxlJobInfo = this.xxlJobService.add(jobInfo);
        return Result.ok((Object)xxlJobInfo);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1")
    public Result update(@RequestBody XxlJobInfoReqVo params) {
        XxlJobInfo jobInfo = this.xxlJobService.query(Integer.parseInt(params.getId()));
        jobInfo.setAuthor(params.getAuthor());
        jobInfo.setJobDesc(params.getJobDesc());
        jobInfo.setScheduleConf(params.getScheduleConf());
        this.xxlJobService.update(jobInfo);
        return Result.ok();
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    public Result remove(@RequestBody List<String> ids) {
        this.xxlJobService.remove(ids);
        return Result.ok();
    }

    @PostMapping(value={"/stop"})
    @ResponseBody
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1")
    public Result pause(@RequestBody List<Integer> ids) {
        ids.forEach(id -> this.xxlJobService.stop((int)id));
        return Result.ok();
    }

    @PostMapping(value={"/start"})
    @ResponseBody
    @ApiOperation(value="\u5f00\u542f\u4efb\u52a1")
    public Result start(@RequestBody List<Integer> ids) {
        ids.forEach(id -> this.xxlJobService.start((int)id));
        return Result.ok();
    }

    @PostMapping(value={"/trigger"})
    @ResponseBody
    @ApiOperation(value="\u89e6\u53d1\u4e00\u6b21\u4efb\u52a1")
    public Result<Object> triggerJob(@RequestBody XxlJobInfoReqVo vo) {
        if (vo.getExecutorParam() == null) {
            vo.setExecutorParam("");
        }
        JobTriggerPoolHelper.trigger(Integer.parseInt(vo.getId()), TriggerTypeEnum.MANUAL, -1, null, vo.getExecutorParam(), vo.getAddressList());
        return Result.ok();
    }
}

