/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.alarm;

import com.biz.crm.admin.core.alarm.JobAlarm;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class JobAlarmer
implements ApplicationContextAware,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(JobAlarmer.class);
    private ApplicationContext applicationContext;
    private List<JobAlarm> jobAlarmList;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map serviceBeanMap = this.applicationContext.getBeansOfType(JobAlarm.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            this.jobAlarmList = new ArrayList(serviceBeanMap.values());
        }
    }

    public boolean alarm(XxlJobInfo info, XxlJobLog jobLog) {
        boolean result = false;
        if (this.jobAlarmList != null && this.jobAlarmList.size() > 0) {
            result = true;
            for (JobAlarm alarm : this.jobAlarmList) {
                boolean resultItem = false;
                try {
                    resultItem = alarm.doAlarm(info, jobLog);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (resultItem) continue;
                result = false;
            }
        }
        return result;
    }
}

