/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.controller.annotation.PermissionLimit;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobUser;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.mapper.XxlJobGroupDao;
import com.biz.crm.admin.mapper.XxlJobUserDao;
import com.biz.crm.core.biz.model.ReturnT;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
@Api(tags={"\u7528\u6237\u5217\u8868;"})
public class UserController {
    @Resource
    private XxlJobUserDao xxlJobUserDao;
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;

    @RequestMapping
    @PermissionLimit(adminuser=true)
    public String index(Model model) {
        List<XxlJobGroup> groupList = this.xxlJobGroupDao.findAll();
        model.addAttribute("groupList", groupList);
        return "user/user.index";
    }

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public Map<String, Object> pageList(@RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, String username, int role) {
        List<XxlJobUser> list = this.xxlJobUserDao.pageList(start, length, username, role);
        int list_count = this.xxlJobUserDao.pageListCount(start, length, username, role);
        if (list != null && list.size() > 0) {
            for (XxlJobUser item : list) {
                item.setPassword(null);
            }
        }
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237")
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> add(XxlJobUser xxlJobUser) {
        if (!StringUtils.hasText((String)xxlJobUser.getUsername())) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("user_username"));
        }
        xxlJobUser.setUsername(xxlJobUser.getUsername().trim());
        if (xxlJobUser.getUsername().length() < 4 || xxlJobUser.getUsername().length() > 20) {
            return new ReturnT(500, I18nUtil.getString("system_lengh_limit") + "[4-20]");
        }
        if (!StringUtils.hasText((String)xxlJobUser.getPassword())) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("user_password"));
        }
        xxlJobUser.setPassword(xxlJobUser.getPassword().trim());
        if (xxlJobUser.getPassword().length() < 4 || xxlJobUser.getPassword().length() > 20) {
            return new ReturnT(500, I18nUtil.getString("system_lengh_limit") + "[4-20]");
        }
        xxlJobUser.setPassword(DigestUtils.md5DigestAsHex((byte[])xxlJobUser.getPassword().getBytes()));
        XxlJobUser existUser = this.xxlJobUserDao.loadByUserName(xxlJobUser.getUsername());
        if (existUser != null) {
            return new ReturnT(500, I18nUtil.getString("user_username_repeat"));
        }
        this.xxlJobUserDao.save(xxlJobUser);
        return ReturnT.SUCCESS;
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> update(HttpServletRequest request, XxlJobUser xxlJobUser) {
        XxlJobUser loginUser = (XxlJobUser)((Object)request.getAttribute("XXL_JOB_LOGIN_IDENTITY"));
        if (loginUser.getUsername().equals(xxlJobUser.getUsername())) {
            return new ReturnT(ReturnT.FAIL.getCode(), I18nUtil.getString("user_update_loginuser_limit"));
        }
        if (StringUtils.hasText((String)xxlJobUser.getPassword())) {
            xxlJobUser.setPassword(xxlJobUser.getPassword().trim());
            if (xxlJobUser.getPassword().length() < 4 || xxlJobUser.getPassword().length() > 20) {
                return new ReturnT(500, I18nUtil.getString("system_lengh_limit") + "[4-20]");
            }
            xxlJobUser.setPassword(DigestUtils.md5DigestAsHex((byte[])xxlJobUser.getPassword().getBytes()));
        } else {
            xxlJobUser.setPassword(null);
        }
        this.xxlJobUserDao.update(xxlJobUser);
        return ReturnT.SUCCESS;
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @ResponseBody
    @PermissionLimit(adminuser=true)
    public ReturnT<String> remove(HttpServletRequest request, String id) {
        XxlJobUser loginUser = (XxlJobUser)((Object)request.getAttribute("XXL_JOB_LOGIN_IDENTITY"));
        if (loginUser.getId().equals(id)) {
            return new ReturnT(ReturnT.FAIL.getCode(), I18nUtil.getString("user_update_loginuser_limit"));
        }
        this.xxlJobUserDao.delete(id);
        return ReturnT.SUCCESS;
    }

    @PostMapping(value={"/updatePwd"})
    @ApiOperation(value="\u66f4\u65b0\u5bc6\u7801")
    @ResponseBody
    public ReturnT<String> updatePwd(HttpServletRequest request, String password) {
        if (password == null || password.trim().length() == 0) {
            return new ReturnT(ReturnT.FAIL.getCode(), "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if ((password = password.trim()).length() < 4 || password.length() > 20) {
            return new ReturnT(500, I18nUtil.getString("system_lengh_limit") + "[4-20]");
        }
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes());
        XxlJobUser loginUser = (XxlJobUser)((Object)request.getAttribute("XXL_JOB_LOGIN_IDENTITY"));
        XxlJobUser existUser = this.xxlJobUserDao.loadByUserName(loginUser.getUsername());
        existUser.setPassword(md5Password);
        this.xxlJobUserDao.update(existUser);
        return ReturnT.SUCCESS;
    }
}

