/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.biz.crm.admin.controller.annotation.PermissionLimit;
import com.biz.crm.admin.service.LoginService;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.nebular.job.req.JobChartInfoReqVo;
import com.biz.crm.nebular.job.resp.JobChartInfoInfoRespVo;
import com.biz.crm.nebular.job.resp.JobStatisticsInfoRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Api(tags={"\u4efb\u52a1\u7edf\u8ba1\u8868"})
@RequestMapping(value={"/statistics"})
public class IndexController {
    @Resource
    private XxlJobService xxlJobService;
    @Resource
    private LoginService loginService;

    @GetMapping(value={"/statisticsInfo"})
    @ApiOperation(value="\u7edf\u8ba1\u4fe1\u606f")
    @ResponseBody
    public Result<JobStatisticsInfoRespVo> statisticsInfo() {
        return Result.ok((Object)this.xxlJobService.statisticsInfo());
    }

    @ApiOperation(value="\u8c03\u5ea6\u62a5\u8868")
    @PostMapping(value={"/chartInfo"})
    @ResponseBody
    public Result<JobChartInfoInfoRespVo> chartInfo(@RequestBody JobChartInfoReqVo reqVo) {
        return Result.ok((Object)this.xxlJobService.chartInfo(reqVo));
    }

    @PermissionLimit(limit=false)
    public ModelAndView toLogin(HttpServletRequest request, HttpServletResponse response, ModelAndView modelAndView) {
        if (this.loginService.ifLogin(request, response) != null) {
            modelAndView.setView((View)new RedirectView("/", true, false));
            return modelAndView;
        }
        return new ModelAndView("login");
    }

    @ApiOperation(value="\u767b\u5165")
    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    @ResponseBody
    @PermissionLimit(limit=false)
    public ReturnT<String> loginDo(HttpServletRequest request, HttpServletResponse response, String userName, String password, String ifRemember) {
        boolean ifRem = ifRemember != null && ifRemember.trim().length() > 0 && "on".equals(ifRemember);
        return this.loginService.login(request, response, userName, password, ifRem);
    }

    @ApiOperation(value="\u767b\u51fa")
    @RequestMapping(value={"logout"}, method={RequestMethod.POST})
    @ResponseBody
    @PermissionLimit(limit=false)
    public ReturnT<String> logout(HttpServletRequest request, HttpServletResponse response) {
        return this.loginService.logout(request, response);
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }
}

