/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.complete;

import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.admin.core.thread.JobTriggerPoolHelper;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.util.StringUtils;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobCompleter {
    private static Logger logger = LoggerFactory.getLogger(XxlJobCompleter.class);

    public static int updateHandleInfoAndFinish(XxlJobLog xxlJobLog) {
        XxlJobCompleter.finishJob(xxlJobLog);
        if (xxlJobLog.getHandleMsg().length() > 15000) {
            xxlJobLog.setHandleMsg(xxlJobLog.getHandleMsg().substring(0, 15000));
        }
        return XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateById((Object)xxlJobLog);
    }

    private static void finishJob(XxlJobLog xxlJobLog) {
        XxlJobInfo xxlJobInfo;
        String triggerChildMsg = null;
        if (200 == xxlJobLog.getHandleCode() && (xxlJobInfo = XxlJobAdminConfig.getAdminConfig().getXxlJobInfoDao().loadById(xxlJobLog.getJobId())) != null && xxlJobInfo.getChildJobId() != null && xxlJobInfo.getChildJobId().trim().length() > 0) {
            triggerChildMsg = "<br><br><span style=\"color:#00c0ef;\" > >>>>>>>>>>>" + I18nUtil.getString("jobconf_trigger_child_run") + "<<<<<<<<<<< </span><br>";
            String[] childJobIds = xxlJobInfo.getChildJobId().split(",");
            for (int i = 0; i < childJobIds.length; ++i) {
                String childJobId;
                String string = childJobId = childJobIds[i] != null && childJobIds[i].trim().length() > 0 ? childJobIds[i] : null;
                if (StringUtils.isNotEmpty(childJobId)) {
                    JobTriggerPoolHelper.trigger(childJobId, TriggerTypeEnum.PARENT, -1, null, null, null);
                    ReturnT<String> triggerChildResult = ReturnT.SUCCESS;
                    triggerChildMsg = triggerChildMsg + MessageFormat.format(I18nUtil.getString("jobconf_callback_child_msg1"), i + 1, childJobIds.length, childJobIds[i], triggerChildResult.getCode() == 200 ? I18nUtil.getString("system_success") : I18nUtil.getString("system_fail"), triggerChildResult.getMsg());
                    continue;
                }
                triggerChildMsg = triggerChildMsg + MessageFormat.format(I18nUtil.getString("jobconf_callback_child_msg2"), i + 1, childJobIds.length, childJobIds[i]);
            }
        }
        if (triggerChildMsg != null) {
            xxlJobLog.setHandleMsg(xxlJobLog.getHandleMsg() + triggerChildMsg);
        }
    }

    private static boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

