/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.trigger;

import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.XxlJobScheduler;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.core.biz.ExecutorBiz;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.biz.model.TriggerParam;
import com.biz.crm.core.enums.ExecutorBlockStrategyEnum;
import com.biz.crm.core.util.IpUtil;
import com.biz.crm.core.util.ThrowableUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobTrigger {
    private static Logger logger = LoggerFactory.getLogger(XxlJobTrigger.class);

    public static void trigger(String jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorShardingParam, String executorParam, String addressList) {
        String[] shardingArr;
        XxlJobInfo jobInfo = XxlJobAdminConfig.getAdminConfig().getXxlJobInfoDao().loadById(jobId);
        if (jobInfo == null) {
            logger.warn(">>>>>>>>>>>> trigger fail, jobId invalid\uff0cjobId={}", (Object)jobId);
            return;
        }
        if (executorParam != null) {
            jobInfo.setExecutorParam(executorParam);
        }
        int finalFailRetryCount = failRetryCount >= 0 ? failRetryCount : jobInfo.getExecutorFailRetryCount();
        XxlJobGroup group = XxlJobAdminConfig.getAdminConfig().getXxlJobGroupDao().load(jobInfo.getJobGroup());
        if (addressList != null && addressList.trim().length() > 0) {
            group.setAddressType(1);
            group.setAddressList(addressList.trim());
        }
        int[] shardingParam = null;
        if (executorShardingParam != null && (shardingArr = executorShardingParam.split("/")).length == 2 && XxlJobTrigger.isNumeric(shardingArr[0]) && XxlJobTrigger.isNumeric(shardingArr[1])) {
            shardingParam = new int[]{Integer.valueOf(shardingArr[0]), Integer.valueOf(shardingArr[1])};
        }
        if (ExecutorRouteStrategyEnum.SHARDING_BROADCAST == ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) && group.getRegistryList() != null && !group.getRegistryList().isEmpty() && shardingParam == null) {
            for (int i = 0; i < group.getRegistryList().size(); ++i) {
                XxlJobTrigger.processTrigger(group, jobInfo, finalFailRetryCount, triggerType, i, group.getRegistryList().size());
            }
        } else {
            if (shardingParam == null) {
                shardingParam = new int[]{0, 1};
            }
            XxlJobTrigger.processTrigger(group, jobInfo, finalFailRetryCount, triggerType, (int)shardingParam[0], (int)shardingParam[1]);
        }
    }

    private static boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void processTrigger(XxlJobGroup group, XxlJobInfo jobInfo, int finalFailRetryCount, TriggerTypeEnum triggerType, int index, int total) {
        ExecutorBlockStrategyEnum blockStrategy = ExecutorBlockStrategyEnum.match(jobInfo.getExecutorBlockStrategy(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION);
        ExecutorRouteStrategyEnum executorRouteStrategyEnum = ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null);
        String shardingParam = ExecutorRouteStrategyEnum.SHARDING_BROADCAST == executorRouteStrategyEnum ? String.valueOf(index).concat("/").concat(String.valueOf(total)) : null;
        XxlJobLog jobLog = new XxlJobLog();
        jobLog.setJobGroup(jobInfo.getJobGroup());
        jobLog.setJobId(jobInfo.getId());
        jobLog.setTriggerTime(new Date());
        jobLog.setExecutorFailRetryCount(0);
        XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().insert((Object)jobLog);
        logger.debug(">>>>>>>>>>> xxl-job trigger start, jobId:{}", (Object)jobLog.getId());
        TriggerParam triggerParam = new TriggerParam();
        triggerParam.setJobId(jobInfo.getId());
        triggerParam.setExecutorHandler(jobInfo.getExecutorHandler());
        triggerParam.setExecutorParams(jobInfo.getExecutorParam());
        triggerParam.setExecutorBlockStrategy(jobInfo.getExecutorBlockStrategy());
        triggerParam.setExecutorTimeout(jobInfo.getExecutorTimeout());
        triggerParam.setLogId(jobLog.getId());
        triggerParam.setLogDateTime(jobLog.getTriggerTime().getTime());
        triggerParam.setGlueType(jobInfo.getGlueType());
        triggerParam.setGlueSource(jobInfo.getGlueSource());
        triggerParam.setGlueUpdatetime(jobInfo.getGlueUpdatetime().getTime());
        triggerParam.setBroadcastIndex(index);
        triggerParam.setBroadcastTotal(total);
        String address = null;
        ReturnT<Object> routeAddressResult = null;
        if (group.getRegistryList() != null && !group.getRegistryList().isEmpty()) {
            if (ExecutorRouteStrategyEnum.SHARDING_BROADCAST == executorRouteStrategyEnum) {
                address = index < group.getRegistryList().size() ? group.getRegistryList().get(index) : group.getRegistryList().get(0);
            } else {
                routeAddressResult = executorRouteStrategyEnum.getRouter().route(triggerParam, group.getRegistryList());
                if (routeAddressResult.getCode() == 200) {
                    address = (String)routeAddressResult.getContent();
                }
            }
        } else {
            routeAddressResult = new ReturnT(500, I18nUtil.getString("jobconf_trigger_address_empty"));
        }
        ReturnT<String> triggerResult = null;
        triggerResult = address != null ? XxlJobTrigger.runExecutor(triggerParam, address) : new ReturnT(500, null);
        StringBuffer triggerMsgSb = new StringBuffer();
        triggerMsgSb.append(I18nUtil.getString("jobconf_trigger_type")).append("\uff1a").append(triggerType.getTitle());
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobconf_trigger_admin_adress")).append("\uff1a").append(IpUtil.getIp());
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobconf_trigger_exe_regtype")).append("\uff1a").append(group.getAddressType() == 0 ? I18nUtil.getString("jobgroup_field_addressType_0") : I18nUtil.getString("jobgroup_field_addressType_1"));
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobconf_trigger_exe_regaddress")).append("\uff1a").append(group.getRegistryList());
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobinfo_field_executorRouteStrategy")).append("\uff1a").append(executorRouteStrategyEnum.getTitle());
        if (shardingParam != null) {
            triggerMsgSb.append("(" + shardingParam + ")");
        }
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobinfo_field_executorBlockStrategy")).append("\uff1a").append(blockStrategy.getTitle());
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobinfo_field_timeout")).append("\uff1a").append(jobInfo.getExecutorTimeout());
        triggerMsgSb.append("<br>").append(I18nUtil.getString("jobinfo_field_executorFailRetryCount")).append("\uff1a").append(finalFailRetryCount);
        triggerMsgSb.append("<br><br><span style=\"color:#00c0ef;\" > >>>>>>>>>>>" + I18nUtil.getString("jobconf_trigger_run") + "<<<<<<<<<<< </span><br>").append(routeAddressResult != null && routeAddressResult.getMsg() != null ? routeAddressResult.getMsg() + "<br><br>" : "").append(triggerResult.getMsg() != null ? triggerResult.getMsg() : "");
        jobLog.setExecutorAddress(address);
        jobLog.setExecutorHandler(jobInfo.getExecutorHandler());
        jobLog.setExecutorParam(jobInfo.getExecutorParam());
        jobLog.setExecutorShardingParam(shardingParam);
        jobLog.setExecutorFailRetryCount(finalFailRetryCount);
        jobLog.setTriggerCode(triggerResult.getCode());
        jobLog.setTriggerMsg(triggerMsgSb.toString());
        XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateById((Object)jobLog);
        logger.debug(">>>>>>>>>>> xxl-job trigger end, jobId:{}", (Object)jobLog.getId());
    }

    public static ReturnT<String> runExecutor(TriggerParam triggerParam, String address) {
        ReturnT<String> runResult = null;
        try {
            ExecutorBiz executorBiz = XxlJobScheduler.getExecutorBiz(address);
            runResult = executorBiz.run(triggerParam);
        }
        catch (Exception e) {
            logger.error(">>>>>>>>>>> xxl-job trigger error, please check if the executor[{}] is running.", (Object)address, (Object)e);
            runResult = new ReturnT(500, ThrowableUtil.toString(e));
        }
        StringBuffer runResultSB = new StringBuffer(I18nUtil.getString("jobconf_trigger_run") + "\uff1a");
        runResultSB.append("<br>address\uff1a").append(address);
        runResultSB.append("<br>code\uff1a").append(runResult.getCode());
        runResultSB.append("<br>msg\uff1a").append(runResult.getMsg());
        runResult.setMsg(runResultSB.toString());
        return runResult;
    }
}

