/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.route.strategy;

import com.biz.crm.admin.core.route.ExecutorRouter;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.biz.model.TriggerParam;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ExecutorRouteConsistentHash
extends ExecutorRouter {
    private static int VIRTUAL_NODE_NUM = 100;

    private static long hash(String key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported", e);
        }
        md5.reset();
        byte[] keyBytes = null;
        try {
            keyBytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unknown string :" + key, e);
        }
        md5.update(keyBytes);
        byte[] digest = md5.digest();
        long hashCode = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
        long truncateHashCode = hashCode & 0xFFFFFFFFL;
        return truncateHashCode;
    }

    public String hashJob(String jobId, List<String> addressList) {
        TreeMap<Long, String> addressRing = new TreeMap<Long, String>();
        for (String address : addressList) {
            for (int i = 0; i < VIRTUAL_NODE_NUM; ++i) {
                long addressHash = ExecutorRouteConsistentHash.hash("SHARD-" + address + "-NODE-" + i);
                addressRing.put(addressHash, address);
            }
        }
        long jobHash = ExecutorRouteConsistentHash.hash(String.valueOf(jobId));
        SortedMap lastRing = addressRing.tailMap(jobHash);
        if (!lastRing.isEmpty()) {
            return (String)lastRing.get(lastRing.firstKey());
        }
        return (String)addressRing.firstEntry().getValue();
    }

    @Override
    public ReturnT<String> route(TriggerParam triggerParam, List<String> addressList) {
        String address = this.hashJob(triggerParam.getJobId(), addressList);
        return new ReturnT((Object)address);
    }
}

