/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.thread;

import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.core.util.DateUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLosedMonitorHelper {
    private static Logger logger = LoggerFactory.getLogger(JobLosedMonitorHelper.class);
    private static JobLosedMonitorHelper instance = new JobLosedMonitorHelper();
    private Thread monitorThread;
    private volatile boolean toStop = false;

    public static JobLosedMonitorHelper getInstance() {
        return instance;
    }

    public void start() {
        this.monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobLosedMonitorHelper.this.toStop) {
                    block7: {
                        try {
                            Date losedTime = DateUtil.addMinutes(new Date(), -10);
                            List<String> losedJobIds = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().findLostJobIds(losedTime);
                            if (losedJobIds != null && losedJobIds.size() > 0) {
                                for (String logId : losedJobIds) {
                                    XxlJobLog jobLog = new XxlJobLog();
                                    jobLog.setId(logId);
                                    jobLog.setHandleTime(new Date());
                                    jobLog.setHandleCode(500);
                                    jobLog.setHandleMsg(I18nUtil.getString("joblog_lost_fail"));
                                    XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().updateById((Object)jobLog);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (JobLosedMonitorHelper.this.toStop) break block7;
                            logger.error(">>>>>>>>>>> xxl-job, job fail monitor thread error:{}", (Throwable)e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    catch (Exception e) {
                        if (JobLosedMonitorHelper.this.toStop) continue;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, JobLosedMonitorHelper stop");
            }
        });
        this.monitorThread.setDaemon(true);
        this.monitorThread.setName("xxl-job, admin JobLosedMonitorHelper");
        this.monitorThread.start();
        new ReturnT<String>("");
    }

    public void toStop() {
        this.toStop = true;
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

