/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller.resolver;

import com.biz.crm.admin.core.exception.XxlJobException;
import com.biz.crm.admin.core.util.JacksonUtil;
import com.biz.crm.core.biz.model.ReturnT;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class WebExceptionResolver
implements HandlerExceptionResolver {
    private static transient Logger logger = LoggerFactory.getLogger(WebExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        HandlerMethod method;
        ResponseBody responseBody;
        if (!(ex instanceof XxlJobException)) {
            logger.error("WebExceptionResolver:{}", (Throwable)ex);
        }
        boolean isJson = false;
        if (handler instanceof HandlerMethod && (responseBody = (ResponseBody)(method = (HandlerMethod)handler).getMethodAnnotation(ResponseBody.class)) != null) {
            isJson = true;
        }
        ReturnT errorResult = new ReturnT(500, ex.toString().replaceAll("\n", "<br/>"));
        ModelAndView mv = new ModelAndView();
        if (isJson) {
            try {
                response.setContentType("application/json;charset=utf-8");
                response.getWriter().print(JacksonUtil.writeValueAsString(errorResult));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return mv;
        }
        mv.addObject("exceptionMsg", (Object)errorResult.getMsg());
        mv.setViewName("/common/common.exception");
        return mv;
    }
}

