package com.biz.crm.admin.controller;

import com.biz.crm.admin.controller.annotation.PermissionLimit;
import com.biz.crm.admin.service.LoginService;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.core.biz.model.ReturnT;
import com.biz.crm.nebular.job.req.JobChartInfoReqVo;
import com.biz.crm.nebular.job.resp.JobChartInfoInfoRespVo;
import com.biz.crm.nebular.job.resp.JobStatisticsInfoRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * index controller
 *
 * @author xuxueli 2015-12-19 16:13:16
 */
@Controller
@Api(tags = "任务统计表")
@RequestMapping("/statistics")
public class IndexController {

    @Resource
    private XxlJobService xxlJobService;
    @Resource
    private LoginService loginService;

    /**
     * 获取统计信息，包括任务数量，调度次数，执行器数量
     *
     * @return 统计任务回显
     */
    @GetMapping("/statisticsInfo")
    @ApiOperation(value = "统计信息")
    @ResponseBody
    public Result<JobStatisticsInfoRespVo> statisticsInfo() {
        return Result.ok(xxlJobService.statisticsInfo());
    }

    @ApiOperation(value = "调度报表")
    @PostMapping("/chartInfo")
    @ResponseBody
    public Result<JobChartInfoInfoRespVo> chartInfo(@RequestBody JobChartInfoReqVo reqVo) {
        return Result.ok(xxlJobService.chartInfo(reqVo));
    }

//    @RequestMapping("/toLogin")
    @PermissionLimit(limit = false)
    public ModelAndView toLogin(HttpServletRequest request, HttpServletResponse response, ModelAndView modelAndView) {
        if (loginService.ifLogin(request, response) != null) {
            modelAndView.setView(new RedirectView("/", true, false));
            return modelAndView;
        }
        return new ModelAndView("login");
    }

    @ApiOperation(value = "登入")
    @RequestMapping(value = "login", method = RequestMethod.POST)
    @ResponseBody
    @PermissionLimit(limit = false)
    public ReturnT<String> loginDo(HttpServletRequest request, HttpServletResponse response, String userName, String password, String ifRemember) {
        boolean ifRem = (ifRemember != null && ifRemember.trim().length() > 0 && "on".equals(ifRemember)) ? true : false;
        return loginService.login(request, response, userName, password, ifRem);
    }

    @ApiOperation(value = "登出")
    @RequestMapping(value = "logout", method = RequestMethod.POST)
    @ResponseBody
    @PermissionLimit(limit = false)
    public ReturnT<String> logout(HttpServletRequest request, HttpServletResponse response) {
        return loginService.logout(request, response);
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, new CustomDateEditor(dateFormat, true));
    }

}
