package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * xxl-job log for glue, used to track job code process
 * @author xuxueli 2016-5-19 17:57:46
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_logglue")
@CrmTable(name = "xxl_job_logglue",tableNote = "job-任务源码")
public class XxlJobLogGlue extends BaseIdEntity {

	@CrmColumn(name = "job_id", length = 64,note = "任务id")
	private String jobId;

	@CrmColumn(name = "glue_type", length = 64,note = "glue类型")
	private String glueType;

	@CrmColumn(name = "glue_source", length = 4000,note = "glue代码")
	private String glueSource;

	@CrmColumn(name = "glue_remark", length = 255,note = "glue备注")
	private String glueRemark;

	@CrmColumn(name = "add_time", note = "添加时间")
	private Date addTime;

	@CrmColumn(name = "update_time", note = "更新时间")
	private Date updateTime;





}
