package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * Created by xuxueli on 16/9/30.
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_registry")
@CrmTable(name = "xxl_job_registry", tableNote = "job-注册列表")
public class XxlJobRegistry extends BaseIdEntity {

    @CrmColumn(name = "registry_group", length = 64, note = "执行器")
    private String registryGroup;

    @CrmColumn(name = "registry_key", length = 255, note = "注册key")
    private String registryKey;

    @CrmColumn(name = "registry_value", length = 255, note = "注册值")
    private String registryValue;

    @CrmColumn(name = "update_time", note = "更新时间")
    private Date updateTime;

}
