package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

/**
 * @author xuxueli 2019-05-04 16:43:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_user")
@CrmTable(name = "xxl_job_user", tableNote = "job-用户")
public class XxlJobUser extends BaseIdEntity {

	@CrmColumn(name = "user_name", length = 64, note = "用户名")
	private String username;

	@CrmColumn(name = "password", length = 64, note = "密码")
	private String password;

	@CrmColumn(name = "role", length = 64, note = "角色")
	private int role;

	@CrmColumn(name = "permission", length = 64, note = "权限")
	private String permission;	// 权限：执行器ID列表，多个逗号分割

	// plugin
	public boolean validPermission(String jobGroup){
		if (this.role == 1) {
			return true;
		} else {
			if (StringUtils.hasText(this.permission)) {
				for (String permissionItem : this.permission.split(",")) {
					if (String.valueOf(jobGroup).equals(permissionItem)) {
						return true;
					}
				}
			}
			return false;
		}

	}

}
