package com.biz.crm.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.nebular.job.req.JobGroupReqVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by xuxueli on 16/9/30.
 */
@Mapper
public interface XxlJobGroupDao extends BaseMapper<XxlJobGroup> {

    public List<XxlJobGroup> findAll();

    public List<XxlJobGroup> findByAddressType(@Param("addressType") int addressType);

    public int save(XxlJobGroup xxlJobGroup);

    public int update(XxlJobGroup xxlJobGroup);

    public int remove(@Param("id") String id);

    public XxlJobGroup load(@Param("id") String id);

    public List<XxlJobGroup> pageList(Page<XxlJobGroup> page, @Param("vo") JobGroupReqVo vo);

    public int pageListCount(@Param("offset") int offset,
                             @Param("pagesize") int pagesize,
                             @Param("appName") String appName,
                             @Param("title") String title);

}
