package com.biz.crm.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * job info
 * @author xuxueli 2016-1-12 18:03:45
 */
@Mapper
public interface XxlJobInfoDao extends BaseMapper<XxlJobInfo> {

	public List<XxlJobInfo> pageList(Page<XxlJobInfo> page, @Param("vo") XxlJobInfoReqVo vo);
	public int pageListCount(@Param("offset") int offset,
							 @Param("pagesize") int pagesize,
							 @Param("jobGroup") int jobGroup,
							 @Param("triggerStatus") int triggerStatus,
							 @Param("jobDesc") String jobDesc,
							 @Param("executorHandler") String executorHandler,
							 @Param("author") String author);
	
	public int save(XxlJobInfo info);

	public XxlJobInfo loadById(@Param("id") String id);
	
//	public int update(XxlJobInfo xxlJobInfo);
	
	public int delete(@Param("id") String id);

	public List<XxlJobInfo> getJobsByGroup(@Param("jobGroup") String jobGroup);

	public int findAllCount();

	public List<XxlJobInfo> scheduleJobQuery(@Param("maxNextTime") long maxNextTime, @Param("pagesize") int pagesize );

	public int scheduleUpdate(XxlJobInfo xxlJobInfo);


}
