/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.demo;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@MapperScan(value={"com.biz.crm.**.mapper*"})
@SpringBootApplication(scanBasePackages={"com.biz.crm.*", "com.bizunited.nebula.*"})
@EnableTransactionManagement
@EnableSwagger2
@EnableDiscoveryClient
public class ActivitiDemoApplication {
    private static final Logger log = LoggerFactory.getLogger(ActivitiDemoApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        ConfigurableApplicationContext application = SpringApplication.run(ActivitiDemoApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication crm-activiti is running! Access URLs:\n\t\u672c\u5730\u8bbf\u95ee\u5730\u5740: \t\thttp://localhost:" + port + path + "/\n\tswagger\u5730\u5740: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

