/*
 * Decompiled with CFR 0.152.
 */
package cn.com.biz.pi.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PropertyUtils
implements Serializable {
    private static Locale defaultLocale = Locale.ENGLISH;
    private static Logger logger = Logger.getLogger(PropertyUtils.class);
    private static Map<Class<?>, Map<String, PropertyDescriptor>> beanPropertiesMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PropertyDescriptor> initAndGetBeanPropsMap(Object bean) {
        Class<?> beanClass = bean.getClass();
        Map<String, PropertyDescriptor> propsMap = beanPropertiesMap.get(beanClass);
        if (propsMap == null) {
            Map<String, PropertyDescriptor> tmpPropsMap = PropertyUtils.parseProperties(bean);
            Map<Class<?>, Map<String, PropertyDescriptor>> map = beanPropertiesMap;
            synchronized (map) {
                propsMap = beanPropertiesMap.get(beanClass);
                if (propsMap == null) {
                    beanPropertiesMap.put(beanClass, tmpPropsMap);
                    propsMap = tmpPropsMap;
                }
            }
        }
        return propsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProperty(Object bean, String property) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object ret;
        Map<String, PropertyDescriptor> propsMap = PropertyUtils.initAndGetBeanPropsMap(bean);
        PropertyDescriptor pd = propsMap.get(property.toLowerCase(defaultLocale));
        if (pd == null) {
            String detailedErrorMsg = "No property found for " + property + " in class: " + bean.getClass();
            logger.error((Object)detailedErrorMsg);
            throw new NoSuchMethodException(detailedErrorMsg);
        }
        Method method = pd.getGetter();
        logger.debug((Object)("Property method " + method.toGenericString() + " found for " + property));
        boolean invokeSucc = false;
        try {
            ret = method.invoke(bean, new Object[0]);
            invokeSucc = true;
        }
        finally {
            if (!invokeSucc) {
                logger.error((Object)("Exception Raise in property getter call. " + method.toGenericString()));
            }
        }
        return ret;
    }

    public static Object getPropertySafely(Object bean, String property) {
        try {
            return PropertyUtils.getProperty(bean, property);
        }
        catch (NoSuchMethodException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)("fetch non-existed property " + property));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(Object bean, String property, Object value) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Map<String, PropertyDescriptor> propsMap = PropertyUtils.initAndGetBeanPropsMap(bean);
        PropertyDescriptor pd = propsMap.get(property.toLowerCase(defaultLocale));
        if (pd == null) {
            String detailedErrorMsg = "No property found for " + property + " in class: " + bean.getClass();
            logger.error((Object)detailedErrorMsg);
            throw new NoSuchMethodException(detailedErrorMsg);
        }
        Method setter = pd.getSetter();
        if (null == setter) {
            String detailedErrorMsg = "No proper setter found for " + property + " in class: " + bean.getClass();
            logger.error((Object)detailedErrorMsg);
            throw new NoSuchMethodException(detailedErrorMsg);
        }
        boolean success = false;
        try {
            setter.invoke(bean, value);
            success = true;
        }
        finally {
            if (!success) {
                logger.error((Object)("Exception raised in property setter call" + setter.toGenericString()));
            }
        }
    }

    public static boolean setPropertySafely(Object bean, String property, Object value) {
        boolean success = false;
        try {
            PropertyUtils.setProperty(bean, property, value);
            success = true;
        }
        catch (NoSuchMethodException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)"", (Throwable)e);
        }
        return success;
    }

    public static Iterator<String> getProperties(Object bean) {
        final Map<String, PropertyDescriptor> propsMap = PropertyUtils.initAndGetBeanPropsMap(bean);
        return new Iterator<String>(){
            private final Iterator<Map.Entry<String, PropertyDescriptor>> it;
            {
                this.it = propsMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public String next() {
                return this.it.next().getValue().getPropertyName();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Class<?> getPropertyType(Object bean, String property) {
        Map<String, PropertyDescriptor> propsMap = PropertyUtils.initAndGetBeanPropsMap(bean);
        PropertyDescriptor pd = propsMap.get(property = property.toLowerCase(defaultLocale));
        return pd == null ? null : pd.getPropertyType();
    }

    private static Map<String, PropertyDescriptor> parseProperties(Object bean) {
        Method[] methods = bean.getClass().getMethods();
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        for (Method method : methods) {
            Class<?> propertyType;
            PropertyDescriptor pd;
            String propertyName;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && null != (propertyName = PropertyUtils.splitPropertyName(method.getName(), PropertyUtils.isMethodBooleanReturn(method)))) {
                if ("class".equals(propertyName = propertyName.toLowerCase(defaultLocale))) continue;
                pd = (PropertyDescriptor)propertyMap.get(propertyName);
                if (pd == null) {
                    pd = new PropertyDescriptor(propertyName, bean.getClass());
                    propertyMap.put(propertyName, pd);
                }
                pd.setGetter(method);
                pd.setPropertyType(method.getReturnType());
                continue;
            }
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !method.getName().startsWith("set")) continue;
            propertyName = method.getName().substring(3).toLowerCase(defaultLocale);
            pd = (PropertyDescriptor)propertyMap.get(propertyName);
            if (pd == null) {
                pd = new PropertyDescriptor(propertyName, bean.getClass());
                propertyMap.put(propertyName, pd);
            }
            if (null != (propertyType = pd.getPropertyType())) {
                propertyType = PropertyUtils.findPropertyType(bean, propertyName);
                pd.setPropertyType(propertyType);
            }
            if (null == propertyType) {
                logger.error((Object)("no proper property type find for " + propertyName));
            }
            if (method.getParameterTypes()[0] != propertyType) continue;
            pd.setSetter(method);
        }
        return propertyMap;
    }

    private static Class<?> findPropertyType(Object bean, String propertyName) {
        for (Method method : bean.getClass().getMethods()) {
            String tempPropName;
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || null == (tempPropName = PropertyUtils.splitPropertyName(method.getName(), PropertyUtils.isMethodBooleanReturn(method))) || !propertyName.equalsIgnoreCase(tempPropName)) continue;
            return method.getReturnType();
        }
        return null;
    }

    private static boolean isMethodBooleanReturn(Method method) {
        return method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE;
    }

    private static String splitPropertyName(String methodName, boolean isBooleanReturn) {
        return methodName.startsWith("get") || isBooleanReturn && (methodName.startsWith("is") || methodName.startsWith("has")) ? methodName.substring(methodName.startsWith("is") ? 2 : 3) : null;
    }

    static class PropertyDescriptor {
        private final String propertyName;
        private final Class<?> baseClass;
        private Method getter;
        private Method setter;
        private Class<?> propertyType;

        public PropertyDescriptor(String name, Class<?> baseClass) {
            this.propertyName = name;
            this.baseClass = baseClass;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            if (this.getter != null) {
                logger.warn((Object)("duplicated getter for " + this.baseClass.getCanonicalName() + "." + this.propertyName));
            } else {
                this.getter = getter;
                logger.debug((Object)("set getter for " + this.baseClass.getCanonicalName() + "." + this.propertyName + " to " + getter.toGenericString()));
            }
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter) {
            if (this.setter != null) {
                logger.warn((Object)("duplicated setter for " + this.baseClass.getCanonicalName() + "." + this.propertyName));
            } else {
                this.setter = setter;
                logger.debug((Object)("set setter for " + this.baseClass.getCanonicalName() + "." + this.propertyName + " to " + setter.toGenericString()));
            }
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public void setPropertyType(Class<?> propertyType) {
            this.propertyType = propertyType;
        }
    }
}

