/*
 * Decompiled with CFR 0.152.
 */
package cn.com.biz.pi.util.cache.requestcache;

import cn.com.biz.pi.util.cache.requestcache.Cache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheManager
implements Serializable {
    static Logger logger = Logger.getLogger(CacheManager.class);
    private static HashMap<String, Object> cacheMap = new HashMap();

    private CacheManager() {
    }

    private static synchronized Cache getCache(String key) {
        return (Cache)cacheMap.get(key);
    }

    private static synchronized boolean hasCache(String key) {
        return cacheMap.containsKey(key);
    }

    public static synchronized void invalidateAll() {
        cacheMap.clear();
    }

    public static synchronized void invalidate(String key) {
        cacheMap.remove(key);
    }

    private static synchronized void putCache(String key, Cache object) {
        cacheMap.put(key, object);
    }

    public static Cache getContent(String key) {
        if (CacheManager.hasCache(key)) {
            Cache cache = CacheManager.getCache(key);
            if (CacheManager.cacheExpired(cache)) {
                CacheManager.invalidate(key);
                return null;
            }
            return cache;
        }
        return null;
    }

    public static synchronized HashMap<String, Object> getCacheMap() {
        return cacheMap;
    }

    public static void putContent(String key, Object content, long ttl) {
        CacheManager.putContent(key, content, 0L, ttl);
    }

    public static void putContent(String key, Object content, long seq, long ttl) {
        Cache cache = new Cache();
        cache.setKey(key);
        cache.setValue(content);
        cache.setTimeOut(ttl + new Date().getTime());
        cache.setExpired(false);
        cache.setSeq(seq);
        CacheManager.putCache(key, cache);
    }

    public static synchronized int checkCacheExpire() {
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        for (Map.Entry<String, Object> entry : cacheMap.entrySet()) {
            if (!CacheManager.cacheExpired((Cache)entry.getValue())) continue;
            ++i;
            keys.add(entry.getKey());
        }
        logger.debug((Object)("\u5df2\u8fc7\u671f\u7f13\u5b58\u6570\u91cf=:[" + i + "]"));
        for (String key : keys) {
            CacheManager.invalidate(key);
        }
        return i;
    }

    private static boolean cacheExpired(Cache cache) {
        if (cache == null) {
            return false;
        }
        long milisNow = new Date().getTime();
        long milisExpire = cache.getTimeOut();
        if (milisExpire < 0L) {
            return false;
        }
        return milisNow >= milisExpire;
    }
}

