/*
 * Decompiled with CFR 0.152.
 */
package cn.com.biz.pi.util.xmlbuilder;

import cn.com.biz.pi.entity.UserAccount;
import cn.com.biz.pi.util.ConvertUtils;
import cn.com.biz.pi.util.PropertyUtils;
import cn.com.biz.pi.util.xmlbuilder.ActionType;
import cn.com.biz.pi.util.xmlbuilder.BaseCommandPayload;
import cn.com.biz.pi.util.xmlbuilder.Command;
import cn.com.biz.pi.util.xmlbuilder.CommandType;
import cn.com.biz.pi.util.xmlbuilder.Commands;
import cn.com.biz.pi.util.xmlbuilder.PriorityType;
import cn.com.biz.pi.util.xmlbuilder.annotation.XmlAutoWired;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CommandBuilder
implements Serializable {
    private static Logger logger = Logger.getLogger(CommandBuilder.class);

    private static XMLBuilder fillRequestXML(XMLBuilder builder, ActionType action, Object param) {
        builder.e("action").text(action.name());
        try {
            if (param == null) {
                builder.e("param");
            } else if (param instanceof XMLBuilder) {
                builder.e("param").importXMLBuilder((XMLBuilder)param);
            } else if (param.getClass().isAnnotationPresent(XmlAutoWired.class)) {
                builder.e("param").t(CommandBuilder.buildXMLFromBean(param, "contents").asString());
            } else {
                builder.e("param").t(param.toString());
            }
        }
        catch (TransformerException e) {
            logger.debug((Object)"Exception raised in convert", (Throwable)e);
        }
        return builder;
    }

    private static XMLBuilder fillResponseXML(XMLBuilder builder, Long responseTo, int result, Object param, int resultPush) {
        builder.e("responseTo").text(Long.toString(responseTo));
        builder.e("result").text(Integer.toString(result));
        builder.e("resultPush").text(Integer.toString(resultPush));
        try {
            if (param == null) {
                builder.e("extra");
            } else if (param instanceof XMLBuilder) {
                builder.e("extra").importXMLBuilder((XMLBuilder)param);
            } else if (param.getClass().isAnnotationPresent(XmlAutoWired.class)) {
                builder.e("extra").t(CommandBuilder.buildXMLFromBean(param, "contents").asString());
            } else {
                builder.e("extra").text(param.toString());
            }
        }
        catch (TransformerException e) {
            logger.debug((Object)"Exception raised in convert", (Throwable)e);
        }
        return builder;
    }

    public static XMLBuilder buildPayLoad(CommandType cmdType, Object bean) {
        try {
            XMLBuilder builder = XMLBuilder.create((String)"payload");
            if (cmdType == CommandType.request) {
                return CommandBuilder.fillRequestXML(builder, (ActionType)((Object)PropertyUtils.getPropertySafely(bean, "action")), PropertyUtils.getPropertySafely(bean, "extra"));
            }
            if (cmdType == CommandType.response) {
                return CommandBuilder.fillResponseXML(builder, (Long)PropertyUtils.getPropertySafely(bean, "responseTo"), (Integer)PropertyUtils.getPropertySafely(bean, "result"), PropertyUtils.getPropertySafely(bean, "extra"), (Integer)PropertyUtils.getPropertySafely(bean, "resultPush"));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        logger.error((Object)"", (Throwable)new RuntimeException("Unexpected XMLParser configuration error"));
        return null;
    }

    public static XMLBuilder buildXMLFromBean(Object bean, String rootElement) {
        Iterator<String> propertyNames = PropertyUtils.getProperties(bean);
        try {
            XMLBuilder builder = XMLBuilder.create((String)rootElement);
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                Object propertyValue = PropertyUtils.getPropertySafely(bean, propertyName);
                if (propertyValue == null) {
                    builder.e(propertyName);
                    continue;
                }
                if (propertyValue.getClass().isAnnotationPresent(XmlAutoWired.class)) {
                    builder.importXMLBuilder(CommandBuilder.buildXMLFromBean(propertyValue, propertyName));
                    continue;
                }
                builder.e(propertyName).text(propertyValue.toString());
            }
            return builder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        logger.error((Object)"", (Throwable)new RuntimeException("Unexpected XMLParser configuration error"));
        return null;
    }

    public static XMLBuilder buildCommandXML(CommandType cmdType, PriorityType priority, Long seq, Object payLoadBean) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder builder = XMLBuilder.create((String)"command");
        builder.a("priority", priority.name());
        if (seq != null) {
            builder.a("seq", Long.toString(seq));
        }
        builder.e("type").text(cmdType.name());
        if (payLoadBean instanceof BaseCommandPayload) {
            builder.importXMLBuilder(CommandBuilder.buildPayLoad(cmdType, payLoadBean));
        } else {
            builder.e("payload").t(payLoadBean.toString());
        }
        return builder;
    }

    public static XMLBuilder buildCommandsXML(UserAccount ua, List<Command> commands) {
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"commands");
            xmlBuilder.a("ver", Integer.toString(1));
            xmlBuilder.a("count", Integer.toString(commands.size()));
            if (ua != null) {
                xmlBuilder.a("user", ua.getUserName());
                xmlBuilder.a("ticket", ua.getTicket());
            }
            for (Command command : commands) {
                xmlBuilder.importXMLBuilder(command.getXMLBuilder());
            }
            return xmlBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        logger.error((Object)"", (Throwable)new RuntimeException("Unexpected XMLParser configuration error"));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean parseCommands(XmlPullParser xpp, Object bean) throws XmlPullParserException, IOException {
        Throwable e;
        boolean success = false;
        xpp.require(2, null, "commands");
        try {
            Commands commands = (Commands)bean;
            int eventType = xpp.getEventType();
            while (true) {
                if (eventType == 2) {
                    if (xpp.getName().equals("commands")) {
                        CommandBuilder.processAttr(xpp, commands, "commands");
                    } else if (xpp.getName().equals("command")) {
                        Command command = new Command();
                        if (!CommandBuilder.parseCommand(xpp, command)) break;
                        List<Command> commandList = commands.getCommands();
                        if (commandList == null) {
                            commandList = new ArrayList<Command>();
                            commands.setCommands(commandList);
                        }
                        commandList.add(command);
                        logger.info((Object)("parsed command: " + command));
                    }
                } else if (eventType == 3 && xpp.getName().equals("commands")) {
                    logger.debug((Object)("commands parsed oky with " + commands));
                    return true;
                }
                eventType = xpp.next();
            }
            logger.warn((Object)"failed to parse Command");
            return success;
        }
        catch (XmlPullParserException xppe) {
            e = xppe;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        logger.debug((Object)"exception raised in parsing Commands.", e);
        logger.warn((Object)("XmlParing failed at: L" + xpp.getLineNumber() + " C:" + xpp.getColumnNumber()));
        return false;
    }

    public static boolean parseCommand(XmlPullParser xpp, Object bean) throws XmlPullParserException, IOException {
        boolean success = false;
        Throwable e = null;
        xpp.require(2, null, "command");
        try {
            Command command = (Command)bean;
            int eventType = xpp.getEventType();
            while (true) {
                if (eventType == 2) {
                    if (xpp.getName().equals("command")) {
                        CommandBuilder.processAttr(xpp, command, "command");
                    } else if (xpp.getName().equals("type")) {
                        command.setCmdType(CommandType.valueOf(CommandBuilder.processText(xpp, "type").trim()));
                    } else if (xpp.getName().equals("payload")) {
                        BaseCommandPayload payload = new BaseCommandPayload();
                        CommandBuilder.processPayload(xpp, payload);
                        command.setPayload(payload);
                    }
                } else if (eventType == 3 && xpp.getName().equals("command")) break;
                eventType = xpp.next();
            }
            logger.debug((Object)("commands parsed oky with " + command));
            success = true;
            return success;
        }
        catch (XmlPullParserException xppe) {
            e = xppe;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        logger.debug((Object)"exception raised in parsing Commands.", e);
        logger.warn((Object)("XmlParing failed at: L" + xpp.getLineNumber() + " C:" + xpp.getColumnNumber()));
        return false;
    }

    private static void processPayload(XmlPullParser xpp, Object bean) throws XmlPullParserException, IOException {
        int event;
        xpp.require(2, null, "payload");
        while ((event = xpp.next()) != 3 || !xpp.getName().equals("payload")) {
            if (event != 2) continue;
            String elemName = xpp.getName();
            if ("action".equals(elemName)) {
                PropertyUtils.setPropertySafely(bean, "action", (Object)ActionType.valueOf(CommandBuilder.processText(xpp, "action")));
                continue;
            }
            if ("param".equals(elemName)) {
                PropertyUtils.setPropertySafely(bean, "extra", CommandBuilder.processText(xpp, "param"));
                continue;
            }
            if ("responseTo".equals(elemName)) {
                PropertyUtils.setPropertySafely(bean, "responseTo", ConvertUtils.to(Long.class, CommandBuilder.processText(xpp, "responseTo")));
                continue;
            }
            if ("result".equals(elemName)) {
                PropertyUtils.setPropertySafely(bean, "result", ConvertUtils.toInteger(CommandBuilder.processText(xpp, "result")));
                continue;
            }
            if (!"extra".equals(elemName)) continue;
            PropertyUtils.setPropertySafely(bean, "extra", CommandBuilder.processText(xpp, "responseTo"));
        }
    }

    private static String processText(XmlPullParser xpp, String element) throws XmlPullParserException, IOException {
        int event;
        xpp.require(2, null, element);
        StringBuffer text = new StringBuffer();
        int level = 1;
        while ((event = xpp.next()) != 3 || !xpp.getName().equals(element) || level > 1) {
            if (event == 4) {
                text.append(xpp.getText());
                continue;
            }
            if (event == 2) {
                ++level;
                continue;
            }
            if (event != 3) continue;
            --level;
        }
        return text.toString();
    }

    private static void processAttr(XmlPullParser xpp, Object bean, String elementName) throws XmlPullParserException, IOException {
        xpp.require(2, null, elementName);
        int n = xpp.getAttributeCount();
        while (--n > 0) {
            String propertyName = xpp.getAttributeName(n);
            Class<?> propertyType = PropertyUtils.getPropertyType(bean, propertyName);
            if (propertyType == null) continue;
            PropertyUtils.setPropertySafely(bean, propertyName, ConvertUtils.to(propertyType, xpp.getAttributeValue(n)));
        }
    }

    public static void main(String[] args) throws TransformerException {
        ArrayList<Command> commands = new ArrayList<Command>();
        Command command = new Command();
        command.setCmdType(CommandType.response);
        command.setPriority(PriorityType.normal);
        command.setSeq(100L);
        BaseCommandPayload b = new BaseCommandPayload();
        b.setResponseTo(100L);
        b.setExtra("\u8fd9\u662f\u6570\u636e");
        b.setResult(100);
        command.setPayload(b);
        commands.add(command);
        UserAccount u = new UserAccount();
        u.setTicket(String.valueOf(System.currentTimeMillis()));
        XMLBuilder builder = CommandBuilder.buildCommandsXML(u, commands);
    }
}

