/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.eispframework.core.common.model.json.DataGrid;
import org.eispframework.web.system.pojo.base.TSIcon;

public class IconImageUtil
implements Serializable {
    public static void convertDataGrid(DataGrid dataGrid, HttpServletRequest request) {
        String fileDirName = request.getSession().getServletContext().getRealPath("") + File.separator + "temp";
        IconImageUtil.delFolder(fileDirName);
        File fileDir = new File(fileDirName);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        try {
            List list = dataGrid.getResults();
            for (Object obj : list) {
                TSIcon icon = (TSIcon)obj;
                String fileName = "icon" + UUID.randomUUID() + "." + icon.getExtend();
                File tempFile = new File(fileDirName + File.separator + fileName);
                if (icon.getIconContent() == null) continue;
                IconImageUtil.byte2image(icon.getIconContent(), tempFile);
                icon.setIconPath("temp/" + fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byte2image(byte[] data, File file) {
        if (data.length < 3) {
            return;
        }
        FileImageOutputStream imageOutput = null;
        Object fileName = null;
        try {
            imageOutput = new FileImageOutputStream(file);
            imageOutput.write(data, 0, data.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                imageOutput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void delFolder(String folderPath) {
        try {
            IconImageUtil.delAllFile(folderPath);
            File folder = new File(folderPath);
            folder.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            IconImageUtil.delAllFile(path + "/" + tempList[i]);
            IconImageUtil.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }
}

