/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.core.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eispframework.core.util.RandCodeImageEnum;
import org.eispframework.core.util.ResourceUtil;

public class RandCodeImageServlet
extends HttpServlet
implements Serializable {
    private static final long serialVersionUID = -1257947018545327308L;
    public static final String SESSION_KEY_OF_RAND_CODE = "randCode";
    private static final int count = 200;
    private static final int width = 105;
    private static final int height = 35;
    private static final int lineWidth = 2;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        BufferedImage image = new BufferedImage(105, 35, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 105, 35);
        graphics.drawRect(0, 0, 104, 34);
        Random random = new Random();
        for (int i = 0; i < 200; ++i) {
            graphics.setColor(this.getRandColor(150, 200));
            int x = random.nextInt(102) + 1;
            int y = random.nextInt(32) + 1;
            int xl = random.nextInt(2);
            int yl = random.nextInt(2);
            graphics.drawLine(x, y, x + xl, y + yl);
        }
        String resultCode = this.exctractRandCode();
        for (int i = 0; i < resultCode.length(); ++i) {
            graphics.setColor(Color.BLACK);
            graphics.setFont(new Font("Times New Roman", 1, 24));
            graphics.drawString(String.valueOf(resultCode.charAt(i)), 23 * i + 8, 26);
        }
        request.getSession().setAttribute(SESSION_KEY_OF_RAND_CODE, (Object)resultCode);
        graphics.dispose();
        ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)response.getOutputStream());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String exctractRandCode() {
        String randCodeType = ResourceUtil.getRandCodeType();
        int randCodeLength = Integer.parseInt(ResourceUtil.getRandCodeLength());
        if (randCodeType == null) {
            return RandCodeImageEnum.NUMBER_CHAR.generateStr(randCodeLength);
        }
        switch (randCodeType.charAt(0)) {
            case '1': {
                return RandCodeImageEnum.NUMBER_CHAR.generateStr(randCodeLength);
            }
            case '2': {
                return RandCodeImageEnum.LOWER_CHAR.generateStr(randCodeLength);
            }
            case '3': {
                return RandCodeImageEnum.UPPER_CHAR.generateStr(randCodeLength);
            }
            case '4': {
                return RandCodeImageEnum.LETTER_CHAR.generateStr(randCodeLength);
            }
            case '5': {
                return RandCodeImageEnum.ALL_CHAR.generateStr(randCodeLength);
            }
        }
        return RandCodeImageEnum.NUMBER_CHAR.generateStr(randCodeLength);
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

