/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eispframework.validation.ValidationMessage;
import org.eispframework.validation.ValidationStrategy;

public class Validation
implements Serializable {
    private List<ValidationMessage> validationMessageList;
    private List<ValidationStrategy> validationStrategyList = new ArrayList<ValidationStrategy>();
    private boolean isCumulative = true;

    public Validation() {
        this.validationMessageList = new ArrayList<ValidationMessage>();
    }

    public void init() {
        this.validationStrategyList = new ArrayList<ValidationStrategy>();
        this.validationMessageList = new ArrayList<ValidationMessage>();
    }

    public List<ValidationMessage> getValidationMessageList() {
        return this.validationMessageList;
    }

    public void regiesterStrategy(ValidationStrategy validationStrategy) {
        this.validationStrategyList.add(validationStrategy);
    }

    public void clearStategy() {
        this.validationStrategyList.clear();
    }

    public void validate() {
        if (this.validationStrategyList != null && this.validationStrategyList.size() > 0) {
            for (ValidationStrategy vd : this.validationStrategyList) {
                ValidationMessage vm = vd.validate();
                if (vm == null) continue;
                this.validationMessageList.add(vm);
                if (vm.isSuccess() || this.isCumulative()) continue;
                break;
            }
        }
    }

    public boolean isValid() {
        boolean success = true;
        if (this.validationMessageList != null && this.validationMessageList.size() > 0) {
            for (ValidationMessage vm : this.validationMessageList) {
                if (vm.isSuccess()) continue;
                success = vm.isSuccess();
                break;
            }
        }
        return success;
    }

    public void addValidationMessage(ValidationMessage vm) {
        this.validationMessageList.add(vm);
    }

    public void addSuccessMessage(String msg) {
        ValidationMessage vm = new ValidationMessage();
        vm.setSuccess(true);
        vm.setMessage(msg);
        this.validationMessageList.add(vm);
    }

    public boolean isCumulative() {
        return this.isCumulative;
    }

    public void setCumulative(boolean isCumulative) {
        this.isCumulative = isCumulative;
    }
}

