/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.config;

import com.biz.crm.common.captcha.local.service.internal.BlockPuzzleCaptchaServiceImpl;
import com.biz.crm.common.captcha.local.service.internal.CaptchaCacheServiceRedisImpl;
import com.biz.crm.common.captcha.local.service.internal.ClickWordCaptchaServiceImpl;
import com.biz.crm.common.captcha.local.service.internal.FrequenceLimitServiceImpl;
import com.biz.crm.common.captcha.sdk.config.CaptchaProperties;
import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.biz.crm.common.captcha.sdk.service.CaptchaService;
import com.biz.crm.common.captcha.sdk.service.FrequencyLimitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CaptchaProperties.class})
@ConditionalOnProperty(prefix="captcha", name={"enabled"}, havingValue="true")
public class CaptchaConfiguration {
    @Autowired
    private CaptchaProperties prop;

    @Bean
    public CaptchaService getCaptchaService() {
        if (this.prop.getCaptchaType().equals("clickWord")) {
            return new ClickWordCaptchaServiceImpl();
        }
        return new BlockPuzzleCaptchaServiceImpl();
    }

    @Bean
    public CaptchaCacheService getCaptchaCacheService() {
        return new CaptchaCacheServiceRedisImpl();
    }

    @Bean
    public FrequencyLimitService getFrequencyLimitService() {
        return new FrequenceLimitServiceImpl();
    }
}

