package com.biz.crm.common.captcha.local.controller;

import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaService;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;


/**
 * 验证码获取及验证control类
 *
 * @author zwb
 * @date 2021-09-27
 */
@Api(tags = "验证码获取类")
@RestController
@RequestMapping("/v1/captcha")
public class CaptchaController extends BaseController {

  @Autowired(required = false)
  private CaptchaService captchaService;

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaController.class);


  /**
   * 获取一个验证码底图及滑块图片
   *
   * @param request
   * @return
   */
  @PostMapping("/findRootAndSlideImg")
  @ApiOperation("获取一个验证码底图及滑块图片")
  public ResponseModel findRootAndSlideImg(HttpServletRequest request) {
    try {
      CaptchaDto captchaDto=new CaptchaDto();
      captchaDto.setClientUniqueId(getSessionId(request));
      CaptchaDto result = captchaService.getCaptcha(captchaDto);
      return this.buildHttpResult(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 验证图片验证是否正确
   *
   * @param captchaDto
   * @param request
   * @return
   */
  @PostMapping("/checkImg")
  @ApiOperation("验证图片验证是否正确")
  public ResponseModel checkImg(@RequestBody @ApiParam(name = "captchaDto", value = "相关图片底图及滑块图片请求类，主要参数captchaType 验证码类型 pointJson(点坐标(base64加密传输))") CaptchaDto captchaDto, HttpServletRequest request) {
    try {
      captchaDto.setClientUniqueId(captchaDto.getAccount());
      CaptchaDto check = captchaService.checkCaptcha(captchaDto);
      return this.buildHttpResult(check);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 获取sessionId作为用户标识
   *
   * @param request
   * @return
   */
  public String getSessionId(HttpServletRequest request) {
    // 确定当前http请求回话
    String account = request.getParameter("account");
    Validate.isTrue(StringUtils.isNoneBlank(account), "用户标识不能为空");
    LOGGER.debug("当前session id = {}", account);
    return account;
  }


}
