package com.biz.crm.common.captcha.local.service.internal;

import com.biz.crm.common.captcha.sdk.common.constant.RedisKeys;
import com.biz.crm.common.captcha.sdk.config.CaptchaProperties;
import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.biz.crm.common.captcha.sdk.service.FrequencyLimitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/***
 * 验证码接口限流:
 * 根据客户端clientUniqueId
 */
public class FrequenceLimitServiceImpl implements FrequencyLimitService {

  @Autowired
  private CaptchaProperties prop;
  @Autowired
  private CaptchaCacheService cacheService;

  @Override
  public void validateGetImg(CaptchaDto d) {
    Validate.notBlank(d.getClientUniqueId(), "用户标识不能为空");
    String getKey = getKey(d, "GET");
    Long getNum = cacheService.getIncrement(getKey);
    long getCnts;
    if (Objects.isNull(getNum)) {
      getCnts = cacheService.getAndIncrement(getKey, 1, 60, TimeUnit.SECONDS);
    } else {
      getCnts = cacheService.getAndIncrement(getKey, 1);
    }
    // 1分钟内请求次数过多
    Validate.isTrue(getCnts <= prop.getReqGetMinuteLimit(), "接口请求次数超限，请稍后再试！");

  }

  @Override
  public void validateCheckImg(CaptchaDto d) {
    Validate.notBlank(d.getClientUniqueId(), "用户标识不能为空");
    String checkKey = getKey(d, "CHECK");
    Long checkNum = cacheService.getIncrement(checkKey);
    String lockKey = getKey(d,"LOCK");
    // 失败次数过多，锁定
    Validate.isTrue(cacheService.getMCode(lockKey, d.getClientUniqueId()) == null, "接口验证失败数过多，请稍后再试！");

    long checkCnts;
    if (Objects.isNull(checkNum)) {
      checkCnts = cacheService.getAndIncrement(checkKey, 1, 60, TimeUnit.SECONDS);
    } else {
      checkCnts = cacheService.getAndIncrement(checkKey, 1);
    }
    Validate.isTrue(checkCnts <= prop.getReqCheckMinuteLimit(), "接口请求次数超限，请稍后再试！");


    // 失败次数验证
    String failKey = getKey(d, "FAIL");
    Long failNum = cacheService.getIncrement(failKey);
    // 没有验证失败，通过校验
    if (Objects.isNull(failNum)) {
      return;
    }
    // 1分钟内失败5次
    if (failNum > prop.getReqCheckFailLimit()) {
      // get接口锁定5分钟
      cacheService.setMCode(lockKey, "true", prop.getReqCheckFailLockSeconds(), d.getClientUniqueId());
      throw new IllegalStateException("接口验证失败数过多，请稍后再试！");
    }
  }

  /**
   * 拼装之后返回一个包含客户端clientUniqueId的字符串
   *
   * @param input
   * @param type  key类型
   * @return
   */
  private String getKey(CaptchaDto input, String type) {
    return String.format(RedisKeys.CAPTCHA_LIMIT_KEY, type, input.getClientUniqueId());
  }
}




