/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.controller;

import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaService;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9a8c\u8bc1\u7801\u83b7\u53d6\u7c7b"})
@RestController
@RequestMapping(value={"/v1/captcha"})
public class CaptchaController
extends BaseController {
    @Autowired(required=false)
    private CaptchaService captchaService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaController.class);

    @PostMapping(value={"/findRootAndSlideImg"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u9a8c\u8bc1\u7801\u5e95\u56fe\u53ca\u6ed1\u5757\u56fe\u7247")
    public ResponseModel findRootAndSlideImg(HttpServletRequest request) {
        try {
            CaptchaDto captchaDto = new CaptchaDto();
            captchaDto.setClientUniqueId(this.getSessionId(request));
            CaptchaDto result = this.captchaService.getCaptcha(captchaDto);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/checkImg"})
    @ApiOperation(value="\u9a8c\u8bc1\u56fe\u7247\u9a8c\u8bc1\u662f\u5426\u6b63\u786e")
    public ResponseModel checkImg(@RequestBody @ApiParam(name="captchaDto", value="\u76f8\u5173\u56fe\u7247\u5e95\u56fe\u53ca\u6ed1\u5757\u56fe\u7247\u8bf7\u6c42\u7c7b\uff0c\u4e3b\u8981\u53c2\u6570captchaType \u9a8c\u8bc1\u7801\u7c7b\u578b pointJson(\u70b9\u5750\u6807(base64\u52a0\u5bc6\u4f20\u8f93))") CaptchaDto captchaDto, HttpServletRequest request) {
        try {
            captchaDto.setClientUniqueId(captchaDto.getAccount());
            CaptchaDto check = this.captchaService.checkCaptcha(captchaDto);
            return this.buildHttpResult(check);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    public String getSessionId(HttpServletRequest request) {
        String account = request.getParameter("account");
        Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{account}), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LOGGER.debug("\u5f53\u524dsession id = {}", (Object)account);
        return account;
    }
}

