/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.captcha.sdk.common.enums.CaptchaBaseMapEnum;
import com.biz.crm.common.captcha.sdk.config.CaptchaProperties;
import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.dto.PointDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.biz.crm.common.captcha.sdk.service.CaptchaService;
import com.biz.crm.common.captcha.sdk.service.FrequencyLimitService;
import com.bizunited.nebula.common.util.Aes128Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Base64Utils;
import org.springframework.util.FileCopyUtils;

public class BlockPuzzleCaptchaServiceImpl
implements CaptchaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockPuzzleCaptchaServiceImpl.class);
    @Value(value="${security.aes128.key:1234123412ABCDEF}")
    private String encryptKey;
    private static Map<String, String> originalCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> slidingBlockCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String[]> fileNameMap = new ConcurrentHashMap<String, String[]>();
    @Autowired
    private CaptchaCacheService cacheService;
    @Autowired
    private CaptchaProperties prop;
    @Autowired
    private FrequencyLimitService limitHandler;
    private static final String IMAGE_TYPE_PNG = "png";
    private static Long EXPIRESIN_SECONDS = 120L;
    private static Long EXPIRESIN_THREE = 180L;

    @PostConstruct
    public void init() {
        LOGGER.info("\u81ea\u5b9a\u4e49\u914d\u7f6e\u9879\uff1a{}", (Object)this.prop.toString());
        Validate.notNull((Object)this.prop, (String)"\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getInterferenceOptions(), (String)"\u6ed1\u5757\u5e72\u6270\u9879\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.prop.getCaptchaOriginal(), (String)"\u6ed1\u52a8\u62fc\u56fe\u5e95\u56fe\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.prop.getCaptchaSlidingblock(), (String)"\u6ed1\u52a8\u62fc\u56fe\u6ed1\u5757\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getSlipOffset(), (String)"\u6821\u9a8c\u6ed1\u52a8\u62fc\u56fe\u5141\u8bb8\u8bef\u5dee\u504f\u79fb\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqGetMinuteLimit(), (String)"get\u63a5\u53e3\u4e00\u5206\u949f\u5185\u9650\u5236\u8bbf\u95ee\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckMinuteLimit(), (String)"check\u63a5\u53e3\u4e00\u5206\u949f\u5185\u9650\u5236\u8bbf\u95ee\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckFailLimit(), (String)"check\u63a5\u53e3 \u4e00\u5206\u949f\u5185\u5931\u8d25\u6b21\u6570\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckFailLockSeconds(), (String)"check\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25\u540e\uff0c\u63a5\u53e3\u9501\u5b9a\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LOGGER.info("--->>>\u521d\u59cb\u5316\u6587\u5b57\u9a8c\u8bc1\u7801\u5e95\u56fe<<<---");
        this.initializeBaseMap(this.prop.getCaptchaOriginal(), this.prop.getCaptchaSlidingblock());
    }

    public CaptchaDto getCaptcha(CaptchaDto captchaDto) {
        Validate.notBlank((CharSequence)captchaDto.getClientUniqueId(), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.limitHandler.validateGetImg(captchaDto);
        BufferedImage originalImage = this.getOriginal();
        Validate.notNull((Object)originalImage, (String)"\u6ed1\u52a8\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84", (Object[])new Object[0]);
        String jigsawImageBase64 = this.getslidingBlock();
        BufferedImage jigsawImage = this.getBase64StrToImage(jigsawImageBase64);
        Validate.notNull((Object)jigsawImage, (String)"\u6ed1\u5757\u56fe\u7247\u672a\u8f6c\u6362\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84", (Object[])new Object[0]);
        CaptchaDto captcha = this.pictureTemplatesCut(originalImage, jigsawImage, jigsawImageBase64, captchaDto.getClientUniqueId());
        Validate.notNull((Object)captcha, (String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)captcha.getJigsawImageBase64(), (String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u6ed1\u5757\u56fe\u7247\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)captcha.getOriginalImageBase64(), (String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u539f\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        return captcha;
    }

    public CaptchaDto checkCaptcha(CaptchaDto captchaDto) {
        Validate.notBlank((CharSequence)captchaDto.getClientUniqueId(), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.limitHandler.validateCheckImg(captchaDto);
        String codeKey = String.format("captcha:check:token:%s", captchaDto.getToken());
        Validate.isTrue((boolean)this.cacheService.existsMCode(codeKey, captchaDto.getClientUniqueId()), (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01", (Object[])new Object[0]);
        String s = this.cacheService.getMCode(codeKey, captchaDto.getClientUniqueId());
        this.cacheService.deleteMCode(codeKey, captchaDto.getClientUniqueId());
        PointDto point = null;
        PointDto point1 = null;
        String pointJson = null;
        try {
            point = (PointDto)JSON.parseObject((String)s, PointDto.class);
            pointJson = Aes128Utils.decrypt((CharSequence)captchaDto.getPointJson(), (String)this.encryptKey, (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
            point1 = (PointDto)JSON.parseObject((String)pointJson, PointDto.class);
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25");
        }
        if (point.x - this.prop.getSlipOffset() > point1.x || point1.x > point.x + this.prop.getSlipOffset() || point.y != point1.y) {
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        String value = null;
        try {
            value = Aes128Utils.encrypt((CharSequence)captchaDto.getToken().concat("---").concat(pointJson), (String)this.encryptKey, (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        }
        catch (Exception e) {
            LOGGER.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("AES\u52a0\u5bc6\u5931\u8d25");
        }
        String secondKey = String.format("captcha.redis.second.check-%s", value);
        this.cacheService.setMCode(secondKey, captchaDto.getToken(), EXPIRESIN_THREE.longValue(), captchaDto.getClientUniqueId());
        captchaDto.setResult(Boolean.valueOf(true));
        captchaDto.resetClientFlag();
        return captchaDto;
    }

    public void verificationCaptcha(String captchaVerification, String clientUniqueId) {
        try {
            Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)captchaVerification, (String)"\u4e8c\u6b21\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String codeKey = String.format("captcha.redis.second.check-%s", captchaVerification);
            Validate.isTrue((boolean)this.cacheService.existsMCode(codeKey, clientUniqueId), (String)"\u4e8c\u6b21\u9a8c\u8bc1\u5931\u8d25", (Object[])new Object[0]);
            this.cacheService.deleteMCode(codeKey, clientUniqueId);
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25");
        }
    }

    public CaptchaDto pictureTemplatesCut(BufferedImage originalImage, BufferedImage jigsawImage, String jigsawImageBase64, String clientUniqueId) {
        try {
            Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CaptchaDto dataVO = new CaptchaDto();
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            int jigsawWidth = jigsawImage.getWidth();
            int jigsawHeight = jigsawImage.getHeight();
            PointDto point = this.generateJigsawPoint(originalWidth, originalHeight, jigsawWidth, jigsawHeight);
            int x = point.getX();
            int y = point.getY();
            BufferedImage newJigsawImage = new BufferedImage(jigsawWidth, jigsawHeight, jigsawImage.getType());
            Graphics2D graphics = newJigsawImage.createGraphics();
            int bold = 5;
            newJigsawImage = graphics.getDeviceConfiguration().createCompatibleImage(jigsawWidth, jigsawHeight, 3);
            this.cutByTemplate(originalImage, jigsawImage, newJigsawImage, x, 0);
            if (this.prop.getInterferenceOptions() > 0) {
                String s;
                int position = 0;
                position = originalWidth - x - 5 > jigsawWidth * 2 ? this.getRandomInt(x + jigsawWidth + 5, originalWidth - jigsawWidth).intValue() : this.getRandomInt(100, x - jigsawWidth - 5).intValue();
                while (jigsawImageBase64.equals(s = this.getslidingBlock())) {
                }
                this.interferenceByTemplate(originalImage, (BufferedImage)Validate.notNull((Object)this.getBase64StrToImage(s)), position, 0);
            }
            if (this.prop.getInterferenceOptions() > 1) {
                String s;
                while (jigsawImageBase64.equals(s = this.getslidingBlock())) {
                }
                Integer randomInt = this.getRandomInt(jigsawWidth, 100 - jigsawWidth);
                this.interferenceByTemplate(originalImage, Objects.requireNonNull(this.getBase64StrToImage(s)), randomInt, 0);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(bold, 0, 2));
            graphics.drawImage((Image)newJigsawImage, 0, 0, null);
            graphics.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)newJigsawImage, IMAGE_TYPE_PNG, os);
            byte[] jigsawImages = os.toByteArray();
            ByteArrayOutputStream oriImagesOs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalImage, IMAGE_TYPE_PNG, oriImagesOs);
            byte[] oriCopyImages = oriImagesOs.toByteArray();
            dataVO.setOriginalImageBase64(Base64Utils.encodeToString((byte[])oriCopyImages).replaceAll("\r|\n", ""));
            dataVO.setJigsawImageBase64(Base64Utils.encodeToString((byte[])jigsawImages).replaceAll("\r|\n", ""));
            dataVO.setToken(this.getUUID());
            String codeKey = String.format("captcha:check:token:%s", dataVO.getToken());
            this.cacheService.setMCode(codeKey, JSON.toJSONString((Object)point), EXPIRESIN_SECONDS.longValue(), clientUniqueId);
            LOGGER.debug("token\uff1a{},point:{}", (Object)dataVO.getToken(), (Object)JSON.toJSONString((Object)point));
            return dataVO;
        }
        catch (Exception e) {
            LOGGER.error("\u5207\u56fe\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u5207\u56fe\u5931\u8d25", e);
        }
    }

    public PointDto generateJigsawPoint(int originalWidth, int originalHeight, int jigsawWidth, int jigsawHeight) {
        Random random = new Random();
        int widthDifference = originalWidth - jigsawWidth;
        int heightDifference = originalHeight - jigsawHeight;
        int y = 0;
        int x = widthDifference <= 0 ? 5 : random.nextInt(originalWidth - jigsawWidth - 100) + 100;
        y = heightDifference <= 0 ? 5 : random.nextInt(originalHeight - jigsawHeight) + 5;
        return new PointDto(x, y);
    }

    public void cutByTemplate(BufferedImage oriImage, BufferedImage templateImage, BufferedImage newImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    newImage.setRGB(i, j, oriImage.getRGB(x + i, y + j));
                    this.readPixel(oriImage, x + i, y + j, values);
                    this.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, this.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                if (!(rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0) && (rgb >= 0 || downRgb < 0)) continue;
                newImage.setRGB(i, j, Color.white.getRGB());
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }

    public void interferenceByTemplate(BufferedImage oriImage, BufferedImage templateImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    this.readPixel(oriImage, x + i, y + j, values);
                    this.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, this.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                if (!(rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0) && (rgb >= 0 || downRgb < 0)) continue;
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }

    public void readPixel(BufferedImage img, int x, int y, int[] pixels) {
        int xStart = x - 1;
        int yStart = y - 1;
        int current = 0;
        for (int i = xStart; i < 3 + xStart; ++i) {
            for (int j = yStart; j < 3 + yStart; ++j) {
                int tx = i;
                if (tx < 0) {
                    tx = -tx;
                } else if (tx >= img.getWidth()) {
                    tx = x;
                }
                int ty = j;
                if (ty < 0) {
                    ty = -ty;
                } else if (ty >= img.getHeight()) {
                    ty = y;
                }
                pixels[current++] = img.getRGB(tx, ty);
            }
        }
    }

    public void fillMatrix(int[][] matrix, int[] values) {
        int filled = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[] x = matrix[i];
            for (int j = 0; j < x.length; ++j) {
                x[j] = values[filled++];
            }
        }
    }

    public int avgMatrix(int[][] matrix) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[] x = matrix[i];
            for (int j = 0; j < x.length; ++j) {
                if (j == 1) continue;
                Color c = new Color(x[j]);
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
            }
        }
        return new Color(r / 8, g / 8, b / 8).getRGB();
    }

    public void initializeBaseMap(String original, String slidingblock) {
        this.cacheBootImage(this.getResourcesImagesFile(original + "/*.png"), this.getResourcesImagesFile(slidingblock + "/*.png"));
    }

    public void cacheBootImage(Map<String, String> originalMap, Map<String, String> slidingBlockMap) {
        originalCacheMap.putAll(originalMap);
        slidingBlockCacheMap.putAll(slidingBlockMap);
        fileNameMap.put(CaptchaBaseMapEnum.ORIGINAL.getCodeValue(), originalCacheMap.keySet().toArray(new String[0]));
        fileNameMap.put(CaptchaBaseMapEnum.SLIDING_BLOCK.getCodeValue(), slidingBlockCacheMap.keySet().toArray(new String[0]));
        LOGGER.info("\u81ea\u5b9a\u4e49resource\u5e95\u56fe:{}", (Object)JSON.toJSONString(fileNameMap));
    }

    public Map<String, String> getResourcesImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(path)) {
                byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
                String string = Base64Utils.encodeToString((byte[])bytes);
                String filename = resource.getFilename();
                imgMap.put(filename, string);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8def\u5f84\u4e0b\u7684\u6240\u6709\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u83b7\u53d6\u8def\u5f84\u4e0b\u7684\u6240\u6709\u6587\u4ef6\u5931\u8d25", e);
        }
        return imgMap;
    }

    public void afterValidateFail(CaptchaDto data) {
        String fails = String.format("captcha.req.limit-%s-%s", "FAIL", data.getClientUniqueId());
        this.cacheService.getAndIncrement(fails, 1L, 60L, TimeUnit.SECONDS);
    }

    public BufferedImage getOriginal() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.ORIGINAL.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = this.getRandomInt(0, strings.length);
        String s = originalCacheMap.get(strings[randomInt]);
        return this.getBase64StrToImage(s);
    }

    public String getslidingBlock() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.SLIDING_BLOCK.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = this.getRandomInt(0, strings.length);
        String s = slidingBlockCacheMap.get(strings[randomInt]);
        return s;
    }

    public BufferedImage getBase64StrToImage(String base64String) {
        BufferedImage bufferedImage;
        byte[] bytes = Base64Utils.decodeFromString((String)base64String);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("\u5b57\u7b26\u4e32\u8f6c\u56fe\u7247\u5931\u8d25", (Throwable)e);
                throw new IllegalStateException("\u5b57\u7b26\u4e32\u8f6c\u56fe\u7247\u5931\u8d25", e);
            }
        }
        inputStream.close();
        return bufferedImage;
    }

    public String getUUID() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid;
    }

    public Integer getRandomInt(int startNum, int endNum) {
        return ThreadLocalRandom.current().nextInt(endNum - startNum) + startNum;
    }
}

