/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.service.internal;

import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class CaptchaCacheServiceRedisImpl
implements CaptchaCacheService {
    @Autowired
    private RedisMutexService redisMutexService;

    public void setMCode(String key, String value, long expiresInSeconds, String clientUniqueId) {
        Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String mapName = String.format("captcha:map:name:%s", clientUniqueId);
        this.redisMutexService.setMCode(mapName, key, value, expiresInSeconds * 1000L);
    }

    public boolean existsMCode(String key, String clientUniqueId) {
        Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String mapName = String.format("captcha:map:name:%s", clientUniqueId);
        String mCode = this.redisMutexService.getMCode(mapName, key);
        return mCode != null;
    }

    public void deleteMCode(String key, String clientUniqueId) {
        Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String mapName = String.format("captcha:map:name:%s", clientUniqueId);
        this.redisMutexService.removeMCode(mapName, key);
    }

    public String getMCode(String key, String clientUniqueId) {
        Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String mapName = String.format("captcha:map:name:%s", clientUniqueId);
        return this.redisMutexService.getMCode(mapName, key);
    }

    public Long getAndIncrement(String code, long min, long expire, TimeUnit unit) {
        return this.redisMutexService.getAndIncrement(code, min, expire, unit);
    }

    public Long getIncrement(String code) {
        return this.redisMutexService.getIncrement(code);
    }

    public long getAndIncrement(String code, long min) {
        return this.redisMutexService.getAndIncrement(code, min);
    }
}

