/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.captcha.sdk.common.enums.CaptchaBaseMapEnum;
import com.biz.crm.common.captcha.sdk.config.CaptchaProperties;
import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.dto.PointDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.biz.crm.common.captcha.sdk.service.CaptchaService;
import com.biz.crm.common.captcha.sdk.service.FrequencyLimitService;
import com.bizunited.nebula.common.util.Aes128Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Base64Utils;
import org.springframework.util.FileCopyUtils;

public class ClickWordCaptchaServiceImpl
implements CaptchaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickWordCaptchaServiceImpl.class);
    @Autowired
    private FrequencyLimitService limitHandler;
    @Autowired
    private CaptchaProperties prop;
    @Autowired
    private CaptchaCacheService cacheService;
    @Value(value="${security.aes128.key:1234123412ABCDEF}")
    private String encryptKey;
    private static Long EXPIRESIN_SECONDS = 120L;
    private static Long EXPIRESIN_THREE = 180L;
    private static Map<String, String> originalCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> picClickCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String[]> fileNameMap = new ConcurrentHashMap<String, String[]>();
    private static String HAN_ZI = "\u7684\u4e00\u4e86\u662f\u6211\u4e0d\u5728\u4eba\u4eec\u6709\u6765\u4ed6\u8fd9\u4e0a\u7740\u4e2a\u5730\u5230\u5927\u91cc\u8bf4\u5c31\u53bb\u5b50\u5f97\u4e5f\u548c\u90a3\u8981\u4e0b\u770b\u5929\u65f6\u8fc7\u51fa\u5c0f\u4e48\u8d77\u4f60\u90fd\u628a\u597d\u8fd8\u591a\u6ca1\u4e3a\u53c8\u53ef\u5bb6\u5b66\u53ea\u4ee5\u4e3b\u4f1a\u6837\u5e74\u60f3\u751f\u540c\u8001\u4e2d\u5341\u4ece\u81ea\u9762\u524d\u5934\u9053\u5b83\u540e\u7136\u8d70\u5f88\u50cf\u89c1\u4e24\u7528\u5979\u56fd\u52a8\u8fdb\u6210\u56de\u4ec0\u8fb9\u4f5c\u5bf9\u5f00\u800c\u5df1\u4e9b\u73b0\u5c71\u6c11\u5019\u7ecf\u53d1\u5de5\u5411\u4e8b\u547d\u7ed9\u957f\u6c34\u51e0\u4e49\u4e09\u58f0\u4e8e\u9ad8\u624b\u77e5\u7406\u773c\u5fd7\u70b9\u5fc3\u6218\u4e8c\u95ee\u4f46\u8eab\u65b9\u5b9e\u5403\u505a\u53eb\u5f53\u4f4f\u542c\u9769\u6253\u5462\u771f\u5168\u624d\u56db\u5df2\u6240\u654c\u4e4b\u6700\u5149\u4ea7\u60c5\u8def\u5206\u603b\u6761\u767d\u8bdd\u4e1c\u5e2d\u6b21\u4eb2\u5982\u88ab\u82b1\u53e3\u653e\u513f\u5e38\u6c14\u4e94\u7b2c\u4f7f\u5199\u519b\u5427\u6587\u8fd0\u518d\u679c\u600e\u5b9a\u8bb8\u5feb\u660e\u884c\u56e0\u522b\u98de\u5916\u6811\u7269\u6d3b\u90e8\u95e8\u65e0\u5f80\u8239\u671b\u65b0\u5e26\u961f\u5148\u529b\u5b8c\u5374\u7ad9\u4ee3\u5458\u673a\u66f4\u4e5d\u60a8\u6bcf\u98ce\u7ea7\u8ddf\u7b11\u554a\u5b69\u4e07\u5c11\u76f4\u610f\u591c\u6bd4\u9636\u8fde\u8f66\u91cd\u4fbf\u6597\u9a6c\u54ea\u5316\u592a\u6307\u53d8\u793e\u4f3c\u58eb\u8005\u5e72\u77f3\u6ee1\u65e5\u51b3\u767e\u539f\u62ff\u7fa4\u7a76\u5404\u516d\u672c\u601d\u89e3\u7acb\u6cb3\u6751\u516b\u96be\u65e9\u8bba\u5417\u6839\u5171\u8ba9\u76f8\u7814\u4eca\u5176\u4e66\u5750\u63a5\u5e94\u5173\u4fe1\u89c9\u6b65\u53cd\u5904\u8bb0\u5c06\u5343\u627e\u4e89\u9886\u6216\u5e08\u7ed3\u5757\u8dd1\u8c01\u8349\u8d8a\u5b57\u52a0\u811a\u7d27\u7231\u7b49\u4e60\u9635\u6015\u6708\u9752\u534a\u706b\u6cd5\u9898\u5efa\u8d76\u4f4d\u5531\u6d77\u4e03\u5973\u4efb\u4ef6\u611f\u51c6\u5f20\u56e2\u5c4b\u79bb\u8272\u8138\u7247\u79d1\u5012\u775b\u5229\u4e16\u521a\u4e14\u7531\u9001\u5207\u661f\u5bfc\u665a\u8868\u591f\u6574\u8ba4\u54cd\u96ea\u6d41\u672a\u573a\u8be5\u5e76\u5e95\u6df1\u523b\u5e73\u4f1f\u5fd9\u63d0\u786e\u8fd1\u4eae\u8f7b\u8bb2\u519c\u53e4\u9ed1\u544a\u754c\u62c9\u540d\u5440\u571f\u6e05\u9633\u7167\u529e\u53f2\u6539\u5386\u8f6c\u753b\u9020\u5634\u6b64\u6cbb\u5317\u5fc5\u670d\u96e8\u7a7f\u5185\u8bc6\u9a8c\u4f20\u4e1a\u83dc\u722c\u7761\u5174\u5f62\u91cf\u54b1\u89c2\u82e6\u4f53\u4f17\u901a\u51b2\u5408\u7834\u53cb\u5ea6\u672f\u996d\u516c\u65c1\u623f\u6781\u5357\u67aa\u8bfb\u6c99\u5c81\u7ebf\u91ce\u575a\u7a7a\u6536\u7b97\u81f3\u653f\u57ce\u52b3\u843d\u94b1\u7279\u56f4\u5f1f\u80dc\u6559\u70ed\u5c55\u5305\u6b4c\u7c7b\u6e10\u5f3a\u6570\u4e61\u547c\u6027\u97f3\u7b54\u54e5\u9645\u65e7\u795e\u5ea7\u7ae0\u5e2e\u5566\u53d7\u7cfb\u4ee4\u8df3\u975e\u4f55\u725b\u53d6\u5165\u5cb8\u6562\u6389\u5ffd\u79cd\u88c5\u9876\u6025\u6797\u505c\u606f\u53e5\u533a\u8863\u822c\u62a5\u53f6\u538b\u6162\u53d4\u80cc\u7ec6";
    private static String clickWordFontStr = "NotoSerif-Light.ttf";
    private static Font clickWordFont;
    private static int HAN_ZI_SIZE;
    private static int HAN_ZI_SIZE_HALF;

    @PostConstruct
    public void init() {
        LOGGER.info("\u81ea\u5b9a\u4e49\u914d\u7f6e\u9879\uff1a{}", (Object)this.prop.toString());
        Validate.notNull((Object)this.prop, (String)"\u914d\u7f6e\u6587\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.prop.getCaptchaOriginal(), (String)"\u6587\u5b57\u70b9\u9009\u5e95\u56fe\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getFontType(), (String)"\u70b9\u9009\u6587\u5b57\u9a8c\u8bc1\u7801\u7684\u6587\u5b57\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getFontSize(), (String)"\u70b9\u9009\u6587\u5b57\u9a8c\u8bc1\u7801\u7684\u6587\u5b57\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getFontStyle(), (String)"\u70b9\u9009\u6587\u5b57\u9a8c\u8bc1\u7801\u7684\u6587\u5b57\u6837\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getSlipOffset(), (String)"\u70b9\u9009\u6587\u5b57\u9a8c\u8bc1\u7801\u7684\u5141\u8bb8\u8bef\u5dee\u504f\u79fb\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.isFontColorRandom(), (String)"\u70b9\u9009\u6587\u5b57\u9a8c\u8bc1\u7801\u7684\u6587\u5b57\u989c\u8272\u662f\u5426\u968f\u673a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqGetMinuteLimit(), (String)"get\u63a5\u53e3\u4e00\u5206\u949f\u5185\u9650\u5236\u8bbf\u95ee\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckMinuteLimit(), (String)"check\u63a5\u53e3\u4e00\u5206\u949f\u5185\u9650\u5236\u8bbf\u95ee\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckFailLimit(), (String)"check\u63a5\u53e3 \u4e00\u5206\u949f\u5185\u5931\u8d25\u6b21\u6570\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)this.prop.getReqCheckFailLockSeconds(), (String)"check\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25\u540e\uff0c\u63a5\u53e3\u9501\u5b9a\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LOGGER.info("--->>>\u521d\u59cb\u5316\u9a8c\u8bc1\u7801\u5e95\u56fe<<<---");
        this.initializeBaseMap(this.prop.getCaptchaOriginal());
        clickWordFontStr = this.prop.getFontType();
        try {
            int size;
            HAN_ZI_SIZE = size = this.prop.getFontSize().intValue();
            HAN_ZI_SIZE_HALF = size / 2;
            int style = this.prop.getFontStyle();
            clickWordFont = new Font(clickWordFontStr, style, size);
        }
        catch (Exception ex) {
            LOGGER.error("load font error:{}", (Throwable)ex);
            throw new IllegalStateException("load font error", ex);
        }
    }

    public CaptchaDto getCaptcha(CaptchaDto captchaDto) {
        this.limitHandler.validateGetImg(captchaDto);
        BufferedImage bufferedImage = this.getPicClick();
        Validate.notNull((Object)bufferedImage, (String)"\u6ed1\u52a8\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84", (Object[])new Object[0]);
        CaptchaDto imageData = this.getImageData(bufferedImage, captchaDto.getClientUniqueId());
        Validate.notNull((Object)imageData, (String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)imageData.getOriginalImageBase64(), (String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u5e95\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        return imageData;
    }

    public CaptchaDto checkCaptcha(CaptchaDto captchaDto) {
        Validate.notBlank((CharSequence)captchaDto.getClientUniqueId(), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.limitHandler.validateCheckImg(captchaDto);
        String codeKey = String.format("captcha:check:token:%s", captchaDto.getToken());
        Validate.isTrue((boolean)this.cacheService.existsMCode(codeKey, captchaDto.getClientUniqueId()), (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01", (Object[])new Object[0]);
        String s = this.cacheService.getMCode(codeKey, captchaDto.getClientUniqueId());
        this.cacheService.deleteMCode(codeKey, captchaDto.getClientUniqueId());
        List point = null;
        List point1 = null;
        String pointJson = null;
        try {
            point = JSON.parseArray((String)s, PointDto.class);
            pointJson = Aes128Utils.decrypt((CharSequence)captchaDto.getPointJson(), (String)this.encryptKey, (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
            point1 = JSON.parseArray((String)pointJson, PointDto.class);
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25");
        }
        for (int i = 0; i < point.size(); ++i) {
            if (((PointDto)point.get((int)i)).x - HAN_ZI_SIZE <= ((PointDto)point1.get((int)i)).x && ((PointDto)point1.get((int)i)).x <= ((PointDto)point.get((int)i)).x + HAN_ZI_SIZE && ((PointDto)point.get((int)i)).y - HAN_ZI_SIZE <= ((PointDto)point1.get((int)i)).y && ((PointDto)point1.get((int)i)).y <= ((PointDto)point.get((int)i)).y + HAN_ZI_SIZE) continue;
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        String value = null;
        try {
            value = Aes128Utils.encrypt((CharSequence)captchaDto.getToken().concat("---").concat(pointJson), (String)this.encryptKey, (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        }
        catch (Exception e) {
            LOGGER.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaDto);
            throw new IllegalStateException("AES\u52a0\u5bc6\u5931\u8d25");
        }
        String secondKey = String.format("captcha.redis.second.check-%s", value);
        this.cacheService.setMCode(secondKey, captchaDto.getToken(), EXPIRESIN_THREE.longValue(), captchaDto.getClientUniqueId());
        captchaDto.setResult(Boolean.valueOf(true));
        captchaDto.resetClientFlag();
        return captchaDto;
    }

    public void verificationCaptcha(String captchaVerification, String clientUniqueId) {
        try {
            Validate.notBlank((CharSequence)clientUniqueId, (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)captchaVerification, (String)"\u4e8c\u6b21\u6821\u9a8c\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String codeKey = String.format("captcha.redis.second.check-%s", captchaVerification);
            Validate.isTrue((boolean)this.cacheService.existsMCode(codeKey, clientUniqueId), (String)"\u4e8c\u6b21\u9a8c\u8bc1\u5931\u8d25", (Object[])new Object[0]);
            this.cacheService.deleteMCode(codeKey, clientUniqueId);
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25");
        }
    }

    private CaptchaDto getImageData(BufferedImage backgroundImage, String clientUniqueId) {
        CaptchaDto dataVO = new CaptchaDto();
        ArrayList<String> wordList = new ArrayList<String>();
        ArrayList<PointDto> pointList = new ArrayList<PointDto>();
        Graphics backgroundGraphics = backgroundImage.getGraphics();
        int width = backgroundImage.getWidth();
        int height = backgroundImage.getHeight();
        int wordCount = this.prop.getWordCount();
        int num = this.getRandomInt(1, wordCount);
        Set<String> currentWords = this.getRandomWords(wordCount);
        int i = 0;
        for (String word : currentWords) {
            PointDto point = this.randomWordPoint(width, height, i, wordCount);
            if (this.prop.isFontColorRandom()) {
                backgroundGraphics.setColor(new Color(this.getRandomInt(1, 255), this.getRandomInt(1, 255), this.getRandomInt(1, 255)));
            } else {
                backgroundGraphics.setColor(Color.BLACK);
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(this.getRandomInt(-45, 45).intValue()), 0.0, 0.0);
            Font rotatedFont = clickWordFont.deriveFont(affineTransform);
            backgroundGraphics.setFont(rotatedFont);
            backgroundGraphics.drawString(word, point.getX(), point.getY());
            if (num - 1 != i) {
                wordList.add(word);
                pointList.add(point);
            }
            ++i;
        }
        BufferedImage combinedImage = new BufferedImage(width, height, 1);
        Graphics combinedGraphics = combinedImage.getGraphics();
        combinedGraphics.drawImage(backgroundImage, 0, 0, null);
        dataVO.setOriginalImageBase64(ClickWordCaptchaServiceImpl.getImageToBase64Str(backgroundImage).replaceAll("\r|\n", ""));
        dataVO.setWordList(wordList);
        dataVO.setToken(this.getUUID());
        String codeKey = String.format("captcha:check:token:%s", dataVO.getToken());
        this.cacheService.setMCode(codeKey, JSON.toJSONString(pointList), EXPIRESIN_SECONDS.longValue(), clientUniqueId);
        return dataVO;
    }

    private Set<String> getRandomWords(int wordCount) {
        HashSet<String> words = new HashSet<String>();
        int size = HAN_ZI.length();
        do {
            String t = HAN_ZI.charAt(ClickWordCaptchaServiceImpl.getRandomInt(size)) + "";
            words.add(t);
        } while (words.size() < wordCount);
        return words;
    }

    private PointDto randomWordPoint(int imageWidth, int imageHeight, int wordSortIndex, int wordCount) {
        int avgWidth = imageWidth / (wordCount + 1);
        int x = avgWidth < HAN_ZI_SIZE_HALF ? this.getRandomInt(1 + HAN_ZI_SIZE_HALF, imageWidth) : (wordSortIndex == 0 ? this.getRandomInt(1 + HAN_ZI_SIZE_HALF, avgWidth * (wordSortIndex + 1) - HAN_ZI_SIZE_HALF).intValue() : this.getRandomInt(avgWidth * wordSortIndex + HAN_ZI_SIZE_HALF, avgWidth * (wordSortIndex + 1) - HAN_ZI_SIZE_HALF).intValue());
        int y = this.getRandomInt(HAN_ZI_SIZE, imageHeight - HAN_ZI_SIZE);
        return new PointDto(x, y);
    }

    public Integer getRandomInt(int startNum, int endNum) {
        return ThreadLocalRandom.current().nextInt(endNum - startNum) + startNum;
    }

    public static int getRandomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static String getImageToBase64Str(BufferedImage templateImage) {
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)templateImage, "png", baos);
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("\u56fe\u7247\u8f6cbase64\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u56fe\u7247\u8f6cbase64\u5931\u8d25", e);
        }
        return Base64Utils.encodeToString((byte[])bytes).trim();
    }

    public BufferedImage getPicClick() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.PIC_CLICK.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = this.getRandomInt(0, strings.length);
        String s = picClickCacheMap.get(strings[randomInt]);
        return this.getBase64StrToImage(s);
    }

    public BufferedImage getBase64StrToImage(String base64String) {
        BufferedImage bufferedImage;
        byte[] bytes = Base64Utils.decodeFromString((String)base64String);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("\u5b57\u7b26\u4e32\u8f6c\u56fe\u7247\u5931\u8d25", (Throwable)e);
                throw new IllegalStateException("\u5b57\u7b26\u4e32\u8f6c\u56fe\u7247\u5931\u8d25", e);
            }
        }
        inputStream.close();
        return bufferedImage;
    }

    public String getUUID() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid;
    }

    public void initializeBaseMap(String original) {
        this.cacheBootImage(this.getResourcesImagesFile(original + "/*.png"));
    }

    public void cacheBootImage(Map<String, String> picClickMap) {
        picClickCacheMap.putAll(picClickMap);
        fileNameMap.put(CaptchaBaseMapEnum.PIC_CLICK.getCodeValue(), picClickCacheMap.keySet().toArray(new String[0]));
        LOGGER.info("\u81ea\u5b9a\u4e49resource\u5e95\u56fe:{}", (Object)JSON.toJSONString(fileNameMap));
    }

    public Map<String, String> getResourcesImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(path)) {
                byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
                String string = Base64Utils.encodeToString((byte[])bytes);
                String filename = resource.getFilename();
                imgMap.put(filename, string);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8def\u5f84\u4e0b\u7684\u6240\u6709\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u83b7\u53d6\u8def\u5f84\u4e0b\u7684\u6240\u6709\u6587\u4ef6\u5931\u8d25", e);
        }
        return imgMap;
    }

    public void afterValidateFail(CaptchaDto data) {
        String fails = String.format("captcha.req.limit-%s-%s", "FAIL", data.getClientUniqueId());
        this.cacheService.getAndIncrement(fails, 1L, 60L, TimeUnit.SECONDS);
    }
}

