/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.captcha.local.service.internal;

import com.biz.crm.common.captcha.sdk.config.CaptchaProperties;
import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;
import com.biz.crm.common.captcha.sdk.service.CaptchaCacheService;
import com.biz.crm.common.captcha.sdk.service.FrequencyLimitService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class FrequenceLimitServiceImpl
implements FrequencyLimitService {
    @Autowired
    private CaptchaProperties prop;
    @Autowired
    private CaptchaCacheService cacheService;

    public void validateGetImg(CaptchaDto d) {
        Validate.notBlank((CharSequence)d.getClientUniqueId(), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String getKey = this.getKey(d, "GET");
        Long getNum = this.cacheService.getIncrement(getKey);
        long getCnts = Objects.isNull(getNum) ? this.cacheService.getAndIncrement(getKey, 1L, 60L, TimeUnit.SECONDS).longValue() : this.cacheService.getAndIncrement(getKey, 1L);
        Validate.isTrue((getCnts <= (long)this.prop.getReqGetMinuteLimit().intValue() ? 1 : 0) != 0, (String)"\u63a5\u53e3\u8bf7\u6c42\u6b21\u6570\u8d85\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
    }

    public void validateCheckImg(CaptchaDto d) {
        Validate.notBlank((CharSequence)d.getClientUniqueId(), (String)"\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String checkKey = this.getKey(d, "CHECK");
        Long checkNum = this.cacheService.getIncrement(checkKey);
        String lockKey = this.getKey(d, "LOCK");
        Validate.isTrue((this.cacheService.getMCode(lockKey, d.getClientUniqueId()) == null ? 1 : 0) != 0, (String)"\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25\u6570\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
        long checkCnts = Objects.isNull(checkNum) ? this.cacheService.getAndIncrement(checkKey, 1L, 60L, TimeUnit.SECONDS).longValue() : this.cacheService.getAndIncrement(checkKey, 1L);
        Validate.isTrue((checkCnts <= (long)this.prop.getReqCheckMinuteLimit().intValue() ? 1 : 0) != 0, (String)"\u63a5\u53e3\u8bf7\u6c42\u6b21\u6570\u8d85\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
        String failKey = this.getKey(d, "FAIL");
        Long failNum = this.cacheService.getIncrement(failKey);
        if (Objects.isNull(failNum)) {
            return;
        }
        if (failNum > (long)this.prop.getReqCheckFailLimit().intValue()) {
            this.cacheService.setMCode(lockKey, "true", (long)this.prop.getReqCheckFailLockSeconds().intValue(), d.getClientUniqueId());
            throw new IllegalStateException("\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25\u6570\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private String getKey(CaptchaDto input, String type) {
        return String.format("captcha.req.limit-%s-%s", type, input.getClientUniqueId());
    }
}

