package com.biz.crm.common.captcha.sdk.common.constant;

/**
 * 验证码相关的redis静态键值
 *
 * @Author: zwb
 * @Date: 2021/11/8 下午4:12
 */
public class RedisKeys {

  private RedisKeys() {
    throw new IllegalStateException("静态变量类不能进行实例化");
  }

  /**
   * 缓存验证码map name KEY
   * 参数：客户端标识码
   */
  public static final String CAPTCHA_MAP_NAME_KEY = "captcha:map:name:%s";

  /**
   * check接口 中token KEY
   * 参数：token
   */
  public static final String CAPTCHA_CHECK_TOKEN_KEY = "captcha:check:token:%s";

  /**
   * 限制类型key
   * 第一个参数：type 第二个参数：客户端标识码
   */
  public static final String  CAPTCHA_LIMIT_KEY = "captcha.req.limit-%s-%s";

  /**
   * 后台二次校验坐标key
   * 第一个参数：type 第二个参数：客户端标识码
   */
  public static final String CAPTCHA_REDIS_SECOND_CHECK_KEY = "captcha.redis.second.check-%s";
}
