package com.biz.crm.common.captcha.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.awt.*;

/**
 * 属性类，对应yml中的每个属性
 *
 * @author zwb
 * @date 2021-09-27
 */
@ConfigurationProperties(CaptchaProperties.PREFIX)
public class CaptchaProperties {
  public static final String PREFIX = "captcha";

  private boolean enabled = false;

  /**
   * 验证码类型 clickWord 点选文字    blockPuzzle 滑块验证
   */
  private String captchaType = "blockPuzzle";

  /**
   * 底图路径.
   */
  private String captchaOriginal = "classpath:images/captcha/original";

  /**
   * 滑块图片路径.
   */
  private String captchaSlidingblock = "classpath:images/captcha/slidingblock";

  /**
   * 校验滑动拼图允许误差偏移量(默认5像素).
   */
  private Integer slipOffset = 5;

  /**
   * 滑块干扰项(0/1/2)
   */
  private Integer interferenceOptions = 2;

  /***
   * get接口一分钟内限制访问数
   */
  private Integer reqGetMinuteLimit = 120;

  /***
   * check接口一分钟内限制访问数
   */
  private Integer reqCheckMinuteLimit = 120;

  /***
   * check接口 一分钟内失败次数限制
   */
  private Integer reqCheckFailLimit = 20;

  /**
   * check接口验证失败后，接口锁定时间
   */
  private Integer reqCheckFailLockSeconds = 360;

  /***
   * verify接口一分钟内限制访问数
   */
  private Integer reqVerifyMinuteLimit = 120;

  /**
   * 点选文字大小
   */
  private Integer fontSize = 25;

  /**
   * 点选文字验证码的文字数量
   */
  private Integer wordCount = 4;

  /**
   * 点选文字 字体颜色是否随机 不随机默认黑色
   */
  private boolean fontColorRandom =true;

  /**
   * 点选文字验证码的文字字体(宋体)
   */
  private String fontType = "\\u5b8b\\u4f53";

  /**
   * 点选文字验证码的文字样式
   */
  private Integer fontStyle = Font.BOLD;

  public boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(boolean enabled) {
    this.enabled = enabled;
  }

  public String getCaptchaType() {
    return captchaType;
  }

  public void setCaptchaType(String captchaType) {
    this.captchaType = captchaType;
  }

  public String getCaptchaOriginal() {
    return captchaOriginal;
  }

  public void setCaptchaOriginal(String captchaOriginal) {
    this.captchaOriginal = captchaOriginal;
  }

  public String getCaptchaSlidingblock() {
    return captchaSlidingblock;
  }

  public void setCaptchaSlidingblock(String captchaSlidingblock) {
    this.captchaSlidingblock = captchaSlidingblock;
  }

  public Integer getSlipOffset() {
    return slipOffset;
  }

  public void setSlipOffset(Integer slipOffset) {
    this.slipOffset = slipOffset;
  }

  public Integer getInterferenceOptions() {
    return interferenceOptions;
  }

  public void setInterferenceOptions(Integer interferenceOptions) {
    this.interferenceOptions = interferenceOptions;
  }

  public Integer getReqGetMinuteLimit() {
    return reqGetMinuteLimit;
  }

  public void setReqGetMinuteLimit(Integer reqGetMinuteLimit) {
    this.reqGetMinuteLimit = reqGetMinuteLimit;
  }

  public Integer getReqCheckMinuteLimit() {
    return reqCheckMinuteLimit;
  }

  public void setReqCheckMinuteLimit(Integer reqCheckMinuteLimit) {
    this.reqCheckMinuteLimit = reqCheckMinuteLimit;
  }

  public Integer getReqCheckFailLimit() {
    return reqCheckFailLimit;
  }

  public void setReqCheckFailLimit(Integer reqCheckFailLimit) {
    this.reqCheckFailLimit = reqCheckFailLimit;
  }

  public Integer getReqCheckFailLockSeconds() {
    return reqCheckFailLockSeconds;
  }

  public void setReqCheckFailLockSeconds(Integer reqCheckFailLockSeconds) {
    this.reqCheckFailLockSeconds = reqCheckFailLockSeconds;
  }

  public Integer getReqVerifyMinuteLimit() {
    return reqVerifyMinuteLimit;
  }

  public void setReqVerifyMinuteLimit(Integer reqVerifyMinuteLimit) {
    this.reqVerifyMinuteLimit = reqVerifyMinuteLimit;
  }

  public Integer getFontSize() {
    return fontSize;
  }

  public void setFontSize(Integer fontSize) {
    this.fontSize = fontSize;
  }

  public Integer getWordCount() {
    return wordCount;
  }

  public void setWordCount(Integer wordCount) {
    this.wordCount = wordCount;
  }

  public boolean isFontColorRandom() {
    return fontColorRandom;
  }

  public void setFontColorRandom(boolean fontColorRandom) {
    this.fontColorRandom = fontColorRandom;
  }

  public String getFontType() {
    return fontType;
  }

  public void setFontType(String fontType) {
    this.fontType = fontType;
  }

  public Integer getFontStyle() {
    return fontStyle;
  }

  public void setFontStyle(Integer fontStyle) {
    this.fontStyle = fontStyle;
  }
}
